/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.client;

import com.google.gerrit.extensions.client.MenuItem;
import java.util.List;
import java.util.Map;

public class GeneralPreferencesInfo {
    public static final int DEFAULT_PAGESIZE = 25;
    public static final int[] PAGESIZE_CHOICES = new int[]{10, 25, 50, 100};
    public Integer changesPerPage;
    public Boolean showSiteHeader;
    public Boolean useFlashClipboard;
    public String downloadScheme;
    public DownloadCommand downloadCommand;
    public DateFormat dateFormat;
    public TimeFormat timeFormat;
    public Boolean expandInlineDiffs;
    public Boolean highlightAssigneeInChangeTable;
    public Boolean relativeDateInChangeTable;
    public DiffView diffView;
    public Boolean sizeBarInChangeTable;
    public Boolean legacycidInChangeTable;
    public ReviewCategoryStrategy reviewCategoryStrategy;
    public Boolean muteCommonPathPrefixes;
    public Boolean signedOffBy;
    public List<MenuItem> my;
    public List<String> changeTable;
    public Map<String, String> urlAliases;
    public EmailStrategy emailStrategy;
    public EmailFormat emailFormat;
    public DefaultBase defaultBaseForMerges;
    public Boolean publishCommentsOnPush;
    public Boolean workInProgressByDefault;

    public boolean isShowInfoInReviewCategory() {
        return this.getReviewCategoryStrategy() != ReviewCategoryStrategy.NONE;
    }

    public DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            return DateFormat.STD;
        }
        return this.dateFormat;
    }

    public TimeFormat getTimeFormat() {
        if (this.timeFormat == null) {
            return TimeFormat.HHMM_12;
        }
        return this.timeFormat;
    }

    public ReviewCategoryStrategy getReviewCategoryStrategy() {
        if (this.reviewCategoryStrategy == null) {
            return ReviewCategoryStrategy.NONE;
        }
        return this.reviewCategoryStrategy;
    }

    public DiffView getDiffView() {
        if (this.diffView == null) {
            return DiffView.SIDE_BY_SIDE;
        }
        return this.diffView;
    }

    public EmailStrategy getEmailStrategy() {
        if (this.emailStrategy == null) {
            return EmailStrategy.ENABLED;
        }
        return this.emailStrategy;
    }

    public EmailFormat getEmailFormat() {
        if (this.emailFormat == null) {
            return EmailFormat.HTML_PLAINTEXT;
        }
        return this.emailFormat;
    }

    public static GeneralPreferencesInfo defaults() {
        GeneralPreferencesInfo p = new GeneralPreferencesInfo();
        p.changesPerPage = 25;
        p.showSiteHeader = true;
        p.useFlashClipboard = true;
        p.emailStrategy = EmailStrategy.ENABLED;
        p.emailFormat = EmailFormat.HTML_PLAINTEXT;
        p.reviewCategoryStrategy = ReviewCategoryStrategy.NONE;
        p.downloadScheme = null;
        p.downloadCommand = DownloadCommand.CHECKOUT;
        p.dateFormat = DateFormat.STD;
        p.timeFormat = TimeFormat.HHMM_12;
        p.expandInlineDiffs = false;
        p.highlightAssigneeInChangeTable = true;
        p.relativeDateInChangeTable = false;
        p.diffView = DiffView.SIDE_BY_SIDE;
        p.sizeBarInChangeTable = true;
        p.legacycidInChangeTable = false;
        p.muteCommonPathPrefixes = true;
        p.signedOffBy = false;
        p.defaultBaseForMerges = DefaultBase.FIRST_PARENT;
        p.publishCommentsOnPush = false;
        p.workInProgressByDefault = false;
        return p;
    }

    public static enum TimeFormat {
        HHMM_12("h:mm a"),
        HHMM_24("HH:mm");

        private final String format;

        private TimeFormat(String format) {
            this.format = format;
        }

        public String getFormat() {
            return this.format;
        }
    }

    public static enum DefaultBase {
        AUTO_MERGE(null),
        FIRST_PARENT(-1);

        private final String base;

        private DefaultBase(String base) {
            this.base = base;
        }

        private DefaultBase(int base) {
            this(Integer.toString(base));
        }

        public String getBase() {
            return this.base;
        }
    }

    public static enum EmailFormat {
        PLAINTEXT,
        HTML_PLAINTEXT;

    }

    public static enum EmailStrategy {
        ENABLED,
        CC_ON_OWN_COMMENTS,
        DISABLED;

    }

    public static enum DiffView {
        SIDE_BY_SIDE,
        UNIFIED_DIFF;

    }

    public static enum ReviewCategoryStrategy {
        NONE,
        NAME,
        EMAIL,
        USERNAME,
        ABBREV;

    }

    public static enum DateFormat {
        STD("MMM d", "MMM d, yyyy"),
        US("MM/dd", "MM/dd/yy"),
        ISO("MM-dd", "yyyy-MM-dd"),
        EURO("d. MMM", "dd.MM.yyyy"),
        UK("dd/MM", "dd/MM/yyyy");

        private final String shortFormat;
        private final String longFormat;

        private DateFormat(String shortFormat, String longFormat) {
            this.shortFormat = shortFormat;
            this.longFormat = longFormat;
        }

        public String getShortFormat() {
            return this.shortFormat;
        }

        public String getLongFormat() {
            return this.longFormat;
        }
    }

    public static enum DownloadCommand {
        REPO_DOWNLOAD,
        PULL,
        CHECKOUT,
        CHERRY_PICK,
        FORMAT_PATCH;

    }
}

