/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.gerrit.extensions.api.lfs.LfsDefinitions;
import com.google.gerrit.extensions.client.GitBasicAuthPolicy;
import com.google.gerrit.httpd.ContainerAuthFilter;
import com.google.gerrit.httpd.ProjectBasicAuthFilter;
import com.google.gerrit.httpd.ProjectOAuthFilter;
import com.google.gerrit.server.config.AuthConfig;
import com.google.inject.Inject;
import com.google.inject.servlet.ServletModule;
import javax.servlet.Filter;

public class GerritAuthModule
extends ServletModule {
    private static final String NOT_AUTHORIZED_LFS_URL_REGEX = "^(?:(?!/a/))" + LfsDefinitions.LFS_URL_WO_AUTH_REGEX;
    private final AuthConfig authConfig;

    @Inject
    GerritAuthModule(AuthConfig authConfig) {
        this.authConfig = authConfig;
    }

    @Override
    protected void configureServlets() {
        Class<? extends Filter> authFilter = GerritAuthModule.retreiveAuthFilterFromConfig(this.authConfig);
        this.filterRegex(NOT_AUTHORIZED_LFS_URL_REGEX, new String[0]).through(authFilter);
        this.filter("/a/*", new String[0]).through(authFilter);
    }

    static Class<? extends Filter> retreiveAuthFilterFromConfig(AuthConfig authConfig) {
        Class authFilter = authConfig.isTrustContainerAuth() ? ContainerAuthFilter.class : (authConfig.getGitBasicAuthPolicy() == GitBasicAuthPolicy.OAUTH ? ProjectOAuthFilter.class : ProjectBasicAuthFilter.class);
        return authFilter;
    }
}

