/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.auth.container;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.httpd.HtmlDomUtil;
import com.google.gerrit.httpd.RemoteUserUtil;
import com.google.gerrit.httpd.WebSession;
import com.google.gerrit.server.account.externalids.ExternalId;
import com.google.gerrit.server.config.AuthConfig;
import com.google.gwtexpui.server.CacheHeaders;
import com.google.gwtjsonrpc.server.RPCServletUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
class HttpAuthFilter
implements Filter {
    private final DynamicItem<WebSession> sessionProvider;
    private final byte[] signInRaw;
    private final byte[] signInGzip;
    private final String loginHeader;
    private final String displaynameHeader;
    private final String emailHeader;
    private final String externalIdHeader;
    private final boolean userNameToLowerCase;

    @Inject
    HttpAuthFilter(DynamicItem<WebSession> webSession, AuthConfig authConfig) throws IOException {
        this.sessionProvider = webSession;
        String pageName = "LoginRedirect.html";
        String doc = HtmlDomUtil.readFile(this.getClass(), "LoginRedirect.html");
        if (doc == null) {
            throw new FileNotFoundException("No LoginRedirect.html in webapp");
        }
        this.signInRaw = doc.getBytes(HtmlDomUtil.ENC);
        this.signInGzip = HtmlDomUtil.compress(this.signInRaw);
        this.loginHeader = MoreObjects.firstNonNull(Strings.emptyToNull(authConfig.getLoginHttpHeader()), "Authorization");
        this.displaynameHeader = Strings.emptyToNull(authConfig.getHttpDisplaynameHeader());
        this.emailHeader = Strings.emptyToNull(authConfig.getHttpEmailHeader());
        this.externalIdHeader = Strings.emptyToNull(authConfig.getHttpExternalIdHeader());
        this.userNameToLowerCase = authConfig.isUserNameToLowerCase();
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isSessionValid((HttpServletRequest)request)) {
            chain.doFilter(request, response);
        } else {
            byte[] tosend;
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse rsp = (HttpServletResponse)response;
            if (RPCServletUtils.acceptsGzipEncoding(req)) {
                rsp.setHeader("Content-Encoding", "gzip");
                tosend = this.signInGzip;
            } else {
                tosend = this.signInRaw;
            }
            CacheHeaders.setNotCacheable(rsp);
            rsp.setContentType("text/html");
            rsp.setCharacterEncoding(HtmlDomUtil.ENC.name());
            rsp.setContentLength(tosend.length);
            try (ServletOutputStream out = rsp.getOutputStream();){
                out.write(tosend);
            }
        }
    }

    private boolean isSessionValid(HttpServletRequest req) {
        WebSession session = this.sessionProvider.get();
        if (session.isSignedIn()) {
            String user = this.getRemoteUser(req);
            return user == null || HttpAuthFilter.correctUser(user, session);
        }
        return false;
    }

    private static boolean correctUser(String user, WebSession session) {
        ExternalId.Key id = session.getLastLoginExternalId();
        return id != null && id.equals(ExternalId.Key.create("gerrit", user));
    }

    String getRemoteUser(HttpServletRequest req) {
        String remoteUser = RemoteUserUtil.getRemoteUser(req, this.loginHeader);
        return this.userNameToLowerCase && remoteUser != null ? remoteUser.toLowerCase(Locale.US) : remoteUser;
    }

    String getRemoteDisplayname(HttpServletRequest req) {
        if (this.displaynameHeader != null) {
            String raw = req.getHeader(this.displaynameHeader);
            return Strings.emptyToNull(new String(raw.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8));
        }
        return null;
    }

    String getRemoteEmail(HttpServletRequest req) {
        if (this.emailHeader != null) {
            return Strings.emptyToNull(req.getHeader(this.emailHeader));
        }
        return null;
    }

    String getRemoteExternalIdToken(HttpServletRequest req) {
        if (this.externalIdHeader != null) {
            return Strings.emptyToNull(req.getHeader(this.externalIdHeader));
        }
        return null;
    }

    String getLoginHeader() {
        return this.loginHeader;
    }

    @Override
    public void init(FilterConfig filterConfig) {
    }

    @Override
    public void destroy() {
    }
}

