/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.raw;

import com.google.gerrit.httpd.raw.BazelBuild;
import com.google.gwtexpui.linker.server.UserAgentRule;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class RecompileGwtUiFilter
implements Filter {
    private final boolean gwtuiRecompile = System.getProperty("gerrit.disable-gwtui-recompile") == null;
    private final UserAgentRule rule = new UserAgentRule();
    private final Set<String> uaInitialized = new HashSet<String>();
    private final Path unpackedWar;
    private final BazelBuild builder;
    private String lastAgent;
    private long lastTime;

    RecompileGwtUiFilter(BazelBuild builder, Path unpackedWar) {
        this.builder = builder;
        this.unpackedWar = unpackedWar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest request, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        String agent = this.rule.select((HttpServletRequest)request);
        if (this.unpackedWar != null && (this.gwtuiRecompile || !this.uaInitialized.contains(agent))) {
            BazelBuild.Label label = this.builder.gwtZipLabel(agent);
            File zip = this.builder.targetPath(label).toFile();
            RecompileGwtUiFilter recompileGwtUiFilter = this;
            synchronized (recompileGwtUiFilter) {
                try {
                    this.builder.build(label);
                }
                catch (BazelBuild.BuildFailureException e) {
                    e.display(label.toString(), (HttpServletResponse)res);
                    return;
                }
                if (!agent.equals(this.lastAgent) || this.lastTime != zip.lastModified()) {
                    this.lastAgent = agent;
                    this.lastTime = zip.lastModified();
                    RecompileGwtUiFilter.unpack(zip, this.unpackedWar.toFile());
                }
            }
            this.uaInitialized.add(agent);
        }
        chain.doFilter(request, res);
    }

    @Override
    public void init(FilterConfig config) {
    }

    @Override
    public void destroy() {
    }

    private static void unpack(File srcwar, File dstwar) throws IOException {
        try (ZipFile zf = new ZipFile(srcwar);){
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                String name = ze.getName();
                if (ze.isDirectory() || name.startsWith("WEB-INF/") || name.startsWith("META-INF/") || name.startsWith("com/google/gerrit/launcher/") || name.equals("Main.class")) continue;
                File rawtmp = new File(dstwar, name);
                RecompileGwtUiFilter.mkdir(rawtmp.getParentFile());
                rawtmp.deleteOnExit();
                OutputStream rawout = Files.newOutputStream(rawtmp.toPath(), new OpenOption[0]);
                Throwable throwable = null;
                try {
                    InputStream in = zf.getInputStream(ze);
                    Throwable throwable2 = null;
                    try {
                        int n;
                        byte[] buf = new byte[4096];
                        while ((n = in.read(buf, 0, buf.length)) > 0) {
                            rawout.write(buf, 0, n);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (in == null) continue;
                        RecompileGwtUiFilter.$closeResource(throwable2, in);
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (rawout == null) continue;
                    RecompileGwtUiFilter.$closeResource(throwable, rawout);
                }
            }
        }
    }

    private static void mkdir(File dir) throws IOException {
        if (!dir.isDirectory()) {
            RecompileGwtUiFilter.mkdir(dir.getParentFile());
            if (!dir.mkdir()) {
                throw new IOException("Cannot mkdir " + dir.getAbsolutePath());
            }
            dir.deleteOnExit();
        }
    }
}

