/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.lucene;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;

public class AutoCommitWriter
extends IndexWriter {
    private boolean autoCommit;

    AutoCommitWriter(Directory dir, IndexWriterConfig config) throws IOException {
        this(dir, config, false);
    }

    AutoCommitWriter(Directory dir, IndexWriterConfig config, boolean autoCommit) throws IOException {
        super(dir, config);
        this.setAutoCommit(autoCommit);
    }

    public void setAutoCommit(boolean enable) {
        this.autoCommit = enable;
    }

    @Override
    public void addDocument(Iterable<? extends IndexableField> doc) throws IOException {
        super.addDocument(doc);
        this.autoFlush();
    }

    @Override
    public void addDocuments(Iterable<? extends Iterable<? extends IndexableField>> docs) throws IOException {
        super.addDocuments(docs);
        this.autoFlush();
    }

    @Override
    public void updateDocuments(Term delTerm, Iterable<? extends Iterable<? extends IndexableField>> docs) throws IOException {
        super.updateDocuments(delTerm, docs);
        this.autoFlush();
    }

    @Override
    public void deleteDocuments(Term ... term) throws IOException {
        super.deleteDocuments(term);
        this.autoFlush();
    }

    @Override
    public synchronized boolean tryDeleteDocument(IndexReader readerIn, int docID) throws IOException {
        boolean ret = super.tryDeleteDocument(readerIn, docID);
        if (ret) {
            this.autoFlush();
        }
        return ret;
    }

    @Override
    public void deleteDocuments(Query ... queries) throws IOException {
        super.deleteDocuments(queries);
        this.autoFlush();
    }

    @Override
    public void updateDocument(Term term, Iterable<? extends IndexableField> doc) throws IOException {
        super.updateDocument(term, doc);
        this.autoFlush();
    }

    @Override
    public void deleteAll() throws IOException {
        super.deleteAll();
        this.autoFlush();
    }

    void manualFlush() throws IOException {
        this.flush();
        if (this.autoCommit) {
            this.commit();
        }
    }

    public void autoFlush() throws IOException {
        if (this.autoCommit) {
            this.manualFlush();
        }
    }
}

