/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.metrics.dropwizard;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.metrics.dropwizard.CallbackMetricGlue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

class CallbackGroup
implements Runnable {
    private static final long PERIOD = TimeUnit.SECONDS.toNanos(2L);
    private final AtomicLong reloadAt;
    private final Runnable trigger;
    private final ImmutableSet<CallbackMetricGlue> metrics;
    private final Object reloadLock = new Object();

    CallbackGroup(Runnable trigger, ImmutableSet<CallbackMetricGlue> metrics) {
        this.reloadAt = new AtomicLong(0L);
        this.trigger = trigger;
        this.metrics = metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.reload()) {
            Object object = this.reloadLock;
            synchronized (object) {
                for (CallbackMetricGlue m : this.metrics) {
                    m.beginSet();
                }
                this.trigger.run();
                for (CallbackMetricGlue m : this.metrics) {
                    m.endSet();
                }
            }
        }
    }

    private boolean reload() {
        long now;
        long next;
        do {
            now = System.nanoTime();
            next = this.reloadAt.get();
            if (next <= now) continue;
            return false;
        } while (!this.reloadAt.compareAndSet(next, now + PERIOD));
        return true;
    }
}

