/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb.server;

import com.google.common.collect.Ordering;
import com.google.gerrit.reviewdb.server.DisallowReadFromChangesReviewDbWrapper;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gwtorm.client.IntKey;

public class ReviewDbUtil {
    private static final Ordering<? extends IntKey<?>> INT_KEY_ORDERING = Ordering.natural().nullsFirst().onResultOf(IntKey::get).nullsFirst();

    public static <K extends IntKey<?>> Ordering<K> intKeyOrdering() {
        return INT_KEY_ORDERING;
    }

    public static ReviewDb unwrapDb(ReviewDb db) {
        if (db instanceof DisallowReadFromChangesReviewDbWrapper) {
            return ((DisallowReadFromChangesReviewDbWrapper)db).unsafeGetDelegate();
        }
        return db;
    }

    private ReviewDbUtil() {
    }
}

