/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.server.git.DestinationList;
import com.google.gerrit.server.git.VersionedMetaData;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.FileMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionedAccountDestinations
extends VersionedMetaData {
    private static final Logger log = LoggerFactory.getLogger(VersionedAccountDestinations.class);
    private final String ref;
    private final DestinationList destinations = new DestinationList();

    public static VersionedAccountDestinations forUser(Account.Id id) {
        return new VersionedAccountDestinations(RefNames.refsUsers(id));
    }

    private VersionedAccountDestinations(String ref) {
        this.ref = ref;
    }

    @Override
    protected String getRefName() {
        return this.ref;
    }

    public DestinationList getDestinationList() {
        return this.destinations;
    }

    @Override
    protected void onLoad() throws IOException, ConfigInvalidException {
        if (this.revision == null) {
            return;
        }
        String prefix = "destinations/";
        for (VersionedMetaData.PathInfo p : this.getPathInfos(true)) {
            String path;
            if (p.fileMode != FileMode.REGULAR_FILE || !(path = p.path).startsWith(prefix)) continue;
            String label = path.substring(prefix.length());
            this.destinations.parseLabel(label, this.readUTF8(path), error -> log.error("Error parsing file {}: {}", (Object)path, (Object)error.getMessage()));
        }
    }

    @Override
    protected boolean onSave(CommitBuilder commit) throws IOException, ConfigInvalidException {
        throw new UnsupportedOperationException("Cannot yet save destinations");
    }
}

