/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.changes;

import com.google.gerrit.extensions.api.changes.DeleteVoteInput;
import com.google.gerrit.extensions.api.changes.RevisionReviewerApi;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.server.api.ApiUtil;
import com.google.gerrit.server.change.DeleteVote;
import com.google.gerrit.server.change.ReviewerResource;
import com.google.gerrit.server.change.VoteResource;
import com.google.gerrit.server.change.Votes;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.Map;

public class RevisionReviewerApiImpl
implements RevisionReviewerApi {
    private final ReviewerResource reviewer;
    private final Votes.List listVotes;
    private final DeleteVote deleteVote;

    @Inject
    RevisionReviewerApiImpl(Votes.List listVotes, DeleteVote deleteVote, @Assisted ReviewerResource reviewer) {
        this.listVotes = listVotes;
        this.deleteVote = deleteVote;
        this.reviewer = reviewer;
    }

    @Override
    public Map<String, Short> votes() throws RestApiException {
        try {
            return this.listVotes.apply(this.reviewer);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot list votes", e);
        }
    }

    @Override
    public void deleteVote(String label) throws RestApiException {
        try {
            this.deleteVote.apply(new VoteResource(this.reviewer, label), null);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot delete vote", e);
        }
    }

    @Override
    public void deleteVote(DeleteVoteInput input) throws RestApiException {
        try {
            this.deleteVote.apply(new VoteResource(this.reviewer, input.label), input);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot delete vote", e);
        }
    }

    static interface Factory {
        public RevisionReviewerApiImpl create(ReviewerResource var1);
    }
}

