/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.projects;

import com.google.gerrit.extensions.api.access.ProjectAccessInfo;
import com.google.gerrit.extensions.api.access.ProjectAccessInput;
import com.google.gerrit.extensions.api.config.AccessCheckInfo;
import com.google.gerrit.extensions.api.config.AccessCheckInput;
import com.google.gerrit.extensions.api.projects.BranchApi;
import com.google.gerrit.extensions.api.projects.BranchInfo;
import com.google.gerrit.extensions.api.projects.ChildProjectApi;
import com.google.gerrit.extensions.api.projects.CommitApi;
import com.google.gerrit.extensions.api.projects.ConfigInfo;
import com.google.gerrit.extensions.api.projects.ConfigInput;
import com.google.gerrit.extensions.api.projects.DashboardApi;
import com.google.gerrit.extensions.api.projects.DashboardInfo;
import com.google.gerrit.extensions.api.projects.DeleteBranchesInput;
import com.google.gerrit.extensions.api.projects.DeleteTagsInput;
import com.google.gerrit.extensions.api.projects.DescriptionInput;
import com.google.gerrit.extensions.api.projects.ProjectApi;
import com.google.gerrit.extensions.api.projects.ProjectInput;
import com.google.gerrit.extensions.api.projects.TagApi;
import com.google.gerrit.extensions.api.projects.TagInfo;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.ProjectInfo;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.NotImplementedException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.api.ApiUtil;
import com.google.gerrit.server.api.projects.BranchApiImpl;
import com.google.gerrit.server.api.projects.ChildProjectApiImpl;
import com.google.gerrit.server.api.projects.CommitApiImpl;
import com.google.gerrit.server.api.projects.DashboardApiImpl;
import com.google.gerrit.server.api.projects.TagApiImpl;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.project.CheckAccess;
import com.google.gerrit.server.project.ChildProjectsCollection;
import com.google.gerrit.server.project.CommitsCollection;
import com.google.gerrit.server.project.CreateAccessChange;
import com.google.gerrit.server.project.CreateProject;
import com.google.gerrit.server.project.DeleteBranches;
import com.google.gerrit.server.project.DeleteTags;
import com.google.gerrit.server.project.GetAccess;
import com.google.gerrit.server.project.GetConfig;
import com.google.gerrit.server.project.GetDescription;
import com.google.gerrit.server.project.ListBranches;
import com.google.gerrit.server.project.ListChildProjects;
import com.google.gerrit.server.project.ListDashboards;
import com.google.gerrit.server.project.ListTags;
import com.google.gerrit.server.project.ProjectJson;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.ProjectsCollection;
import com.google.gerrit.server.project.PutConfig;
import com.google.gerrit.server.project.PutDescription;
import com.google.gerrit.server.project.SetAccess;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ProjectApiImpl
implements ProjectApi {
    private final CurrentUser user;
    private final PermissionBackend permissionBackend;
    private final CreateProject.Factory createProjectFactory;
    private final Factory projectApi;
    private final ProjectsCollection projects;
    private final GetDescription getDescription;
    private final PutDescription putDescription;
    private final ChildProjectApiImpl.Factory childApi;
    private final ChildProjectsCollection children;
    private final ProjectResource project;
    private final ProjectJson projectJson;
    private final String name;
    private final BranchApiImpl.Factory branchApi;
    private final TagApiImpl.Factory tagApi;
    private final GetAccess getAccess;
    private final SetAccess setAccess;
    private final CreateAccessChange createAccessChange;
    private final GetConfig getConfig;
    private final PutConfig putConfig;
    private final Provider<ListBranches> listBranches;
    private final Provider<ListTags> listTags;
    private final DeleteBranches deleteBranches;
    private final DeleteTags deleteTags;
    private final CommitsCollection commitsCollection;
    private final CommitApiImpl.Factory commitApi;
    private final DashboardApiImpl.Factory dashboardApi;
    private final CheckAccess checkAccess;
    private final Provider<ListDashboards> listDashboards;

    @AssistedInject
    ProjectApiImpl(CurrentUser user, PermissionBackend permissionBackend, CreateProject.Factory createProjectFactory, Factory projectApi, ProjectsCollection projects, GetDescription getDescription, PutDescription putDescription, ChildProjectApiImpl.Factory childApi, ChildProjectsCollection children, ProjectJson projectJson, BranchApiImpl.Factory branchApiFactory, TagApiImpl.Factory tagApiFactory, GetAccess getAccess, SetAccess setAccess, CreateAccessChange createAccessChange, GetConfig getConfig, PutConfig putConfig, Provider<ListBranches> listBranches, Provider<ListTags> listTags, DeleteBranches deleteBranches, DeleteTags deleteTags, CommitsCollection commitsCollection, CommitApiImpl.Factory commitApi, DashboardApiImpl.Factory dashboardApi, CheckAccess checkAccess, Provider<ListDashboards> listDashboards, @Assisted ProjectResource project) {
        this(user, permissionBackend, createProjectFactory, projectApi, projects, getDescription, putDescription, childApi, children, projectJson, branchApiFactory, tagApiFactory, getAccess, setAccess, createAccessChange, getConfig, putConfig, listBranches, listTags, deleteBranches, deleteTags, project, commitsCollection, commitApi, dashboardApi, checkAccess, listDashboards, null);
    }

    @AssistedInject
    ProjectApiImpl(CurrentUser user, PermissionBackend permissionBackend, CreateProject.Factory createProjectFactory, Factory projectApi, ProjectsCollection projects, GetDescription getDescription, PutDescription putDescription, ChildProjectApiImpl.Factory childApi, ChildProjectsCollection children, ProjectJson projectJson, BranchApiImpl.Factory branchApiFactory, TagApiImpl.Factory tagApiFactory, GetAccess getAccess, SetAccess setAccess, CreateAccessChange createAccessChange, GetConfig getConfig, PutConfig putConfig, Provider<ListBranches> listBranches, Provider<ListTags> listTags, DeleteBranches deleteBranches, DeleteTags deleteTags, CommitsCollection commitsCollection, CommitApiImpl.Factory commitApi, DashboardApiImpl.Factory dashboardApi, CheckAccess checkAccess, Provider<ListDashboards> listDashboards, @Assisted String name) {
        this(user, permissionBackend, createProjectFactory, projectApi, projects, getDescription, putDescription, childApi, children, projectJson, branchApiFactory, tagApiFactory, getAccess, setAccess, createAccessChange, getConfig, putConfig, listBranches, listTags, deleteBranches, deleteTags, null, commitsCollection, commitApi, dashboardApi, checkAccess, listDashboards, name);
    }

    private ProjectApiImpl(CurrentUser user, PermissionBackend permissionBackend, CreateProject.Factory createProjectFactory, Factory projectApi, ProjectsCollection projects, GetDescription getDescription, PutDescription putDescription, ChildProjectApiImpl.Factory childApi, ChildProjectsCollection children, ProjectJson projectJson, BranchApiImpl.Factory branchApiFactory, TagApiImpl.Factory tagApiFactory, GetAccess getAccess, SetAccess setAccess, CreateAccessChange createAccessChange, GetConfig getConfig, PutConfig putConfig, Provider<ListBranches> listBranches, Provider<ListTags> listTags, DeleteBranches deleteBranches, DeleteTags deleteTags, ProjectResource project, CommitsCollection commitsCollection, CommitApiImpl.Factory commitApi, DashboardApiImpl.Factory dashboardApi, CheckAccess checkAccess, Provider<ListDashboards> listDashboards, String name) {
        this.user = user;
        this.permissionBackend = permissionBackend;
        this.createProjectFactory = createProjectFactory;
        this.projectApi = projectApi;
        this.projects = projects;
        this.getDescription = getDescription;
        this.putDescription = putDescription;
        this.childApi = childApi;
        this.children = children;
        this.projectJson = projectJson;
        this.project = project;
        this.branchApi = branchApiFactory;
        this.tagApi = tagApiFactory;
        this.getAccess = getAccess;
        this.setAccess = setAccess;
        this.getConfig = getConfig;
        this.putConfig = putConfig;
        this.listBranches = listBranches;
        this.listTags = listTags;
        this.deleteBranches = deleteBranches;
        this.deleteTags = deleteTags;
        this.commitsCollection = commitsCollection;
        this.commitApi = commitApi;
        this.createAccessChange = createAccessChange;
        this.dashboardApi = dashboardApi;
        this.checkAccess = checkAccess;
        this.listDashboards = listDashboards;
        this.name = name;
    }

    @Override
    public ProjectApi create() throws RestApiException {
        return this.create(new ProjectInput());
    }

    @Override
    public ProjectApi create(ProjectInput in) throws RestApiException {
        try {
            if (this.name == null) {
                throw new ResourceConflictException("Project already exists");
            }
            if (in.name != null && !this.name.equals(in.name)) {
                throw new BadRequestException("name must match input.name");
            }
            CreateProject impl = this.createProjectFactory.create(this.name);
            this.permissionBackend.user(this.user).checkAny(GlobalPermission.fromAnnotation(impl.getClass()));
            impl.apply(TopLevelResource.INSTANCE, in);
            return this.projectApi.create(this.projects.parse(this.name));
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot create project: " + e.getMessage(), e);
        }
    }

    @Override
    public ProjectInfo get() throws RestApiException {
        if (this.project == null) {
            throw new ResourceNotFoundException(this.name);
        }
        return this.projectJson.format(this.project.getProjectState());
    }

    @Override
    public String description() throws RestApiException {
        return this.getDescription.apply(this.checkExists());
    }

    @Override
    public ProjectAccessInfo access() throws RestApiException {
        try {
            return this.getAccess.apply(this.checkExists());
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot get access rights", e);
        }
    }

    @Override
    public AccessCheckInfo checkAccess(AccessCheckInput in) throws RestApiException {
        try {
            return this.checkAccess.apply(this.checkExists(), in);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot check access rights", e);
        }
    }

    @Override
    public ProjectAccessInfo access(ProjectAccessInput p) throws RestApiException {
        try {
            return this.setAccess.apply(this.checkExists(), p);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot put access rights", e);
        }
    }

    @Override
    public ChangeInfo accessChange(ProjectAccessInput p) throws RestApiException {
        try {
            return this.createAccessChange.apply(this.checkExists(), p).value();
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot put access right change", e);
        }
    }

    @Override
    public void description(DescriptionInput in) throws RestApiException {
        try {
            this.putDescription.apply(this.checkExists(), in);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot put project description", e);
        }
    }

    @Override
    public ConfigInfo config() throws RestApiException {
        return this.getConfig.apply(this.checkExists());
    }

    @Override
    public ConfigInfo config(ConfigInput in) throws RestApiException {
        return this.putConfig.apply(this.checkExists(), in);
    }

    @Override
    public ProjectApi.ListRefsRequest<BranchInfo> branches() {
        return new ProjectApi.ListRefsRequest<BranchInfo>(){

            @Override
            public List<BranchInfo> get() throws RestApiException {
                try {
                    return ((ListBranches)ProjectApiImpl.this.listBranches.get()).request(this).apply(ProjectApiImpl.this.checkExists());
                }
                catch (Exception e) {
                    throw ApiUtil.asRestApiException("Cannot list branches", e);
                }
            }
        };
    }

    @Override
    public ProjectApi.ListRefsRequest<TagInfo> tags() {
        return new ProjectApi.ListRefsRequest<TagInfo>(){

            @Override
            public List<TagInfo> get() throws RestApiException {
                try {
                    return ((ListTags)ProjectApiImpl.this.listTags.get()).request(this).apply(ProjectApiImpl.this.checkExists());
                }
                catch (Exception e) {
                    throw ApiUtil.asRestApiException("Cannot list tags", e);
                }
            }
        };
    }

    @Override
    public List<ProjectInfo> children() throws RestApiException {
        return this.children(false);
    }

    @Override
    public List<ProjectInfo> children(boolean recursive) throws RestApiException {
        ListChildProjects list = this.children.list();
        list.setRecursive(recursive);
        try {
            return list.apply(this.checkExists());
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot list children", e);
        }
    }

    @Override
    public ChildProjectApi child(String name) throws RestApiException {
        try {
            return this.childApi.create(this.children.parse(this.checkExists(), IdString.fromDecoded(name)));
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot parse child project", e);
        }
    }

    @Override
    public BranchApi branch(String ref) throws ResourceNotFoundException {
        return this.branchApi.create(this.checkExists(), ref);
    }

    @Override
    public TagApi tag(String ref) throws ResourceNotFoundException {
        return this.tagApi.create(this.checkExists(), ref);
    }

    @Override
    public void deleteBranches(DeleteBranchesInput in) throws RestApiException {
        try {
            this.deleteBranches.apply(this.checkExists(), in);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot delete branches", e);
        }
    }

    @Override
    public void deleteTags(DeleteTagsInput in) throws RestApiException {
        try {
            this.deleteTags.apply(this.checkExists(), in);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot delete tags", e);
        }
    }

    @Override
    public CommitApi commit(String commit) throws RestApiException {
        try {
            return this.commitApi.create(this.commitsCollection.parse(this.checkExists(), IdString.fromDecoded(commit)));
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot parse commit", e);
        }
    }

    @Override
    public DashboardApi dashboard(String name) throws RestApiException {
        try {
            return this.dashboardApi.create(this.checkExists(), name);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot parse dashboard", e);
        }
    }

    @Override
    public DashboardApi defaultDashboard() throws RestApiException {
        return this.dashboard("default");
    }

    @Override
    public void defaultDashboard(String name) throws RestApiException {
        try {
            this.dashboardApi.create(this.checkExists(), name).setDefault();
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot set default dashboard", e);
        }
    }

    @Override
    public void removeDefaultDashboard() throws RestApiException {
        try {
            this.dashboardApi.create(this.checkExists(), null).setDefault();
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot remove default dashboard", e);
        }
    }

    @Override
    public ProjectApi.ListDashboardsRequest dashboards() throws RestApiException {
        return new ProjectApi.ListDashboardsRequest(){

            @Override
            public List<DashboardInfo> get() throws RestApiException {
                try {
                    List<?> r = ((ListDashboards)ProjectApiImpl.this.listDashboards.get()).apply(ProjectApiImpl.this.checkExists());
                    if (r.isEmpty()) {
                        return Collections.emptyList();
                    }
                    if (r.get(0) instanceof DashboardInfo) {
                        return r.stream().map(i -> (DashboardInfo)i).collect(Collectors.toList());
                    }
                    throw new NotImplementedException("list with inheritance");
                }
                catch (Exception e) {
                    throw ApiUtil.asRestApiException("Cannot list dashboards", e);
                }
            }
        };
    }

    private ProjectResource checkExists() throws ResourceNotFoundException {
        if (this.project == null) {
            throw new ResourceNotFoundException(this.name);
        }
        return this.project;
    }

    static interface Factory {
        public ProjectApiImpl create(ProjectResource var1);

        public ProjectApiImpl create(String var1);
    }
}

