/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.auth.ldap;

import com.google.common.cache.LoadingCache;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.account.GroupMembership;
import com.google.gerrit.server.account.ListGroupMembership;
import com.google.gerrit.server.auth.ldap.LdapGroupBackend;
import com.google.gerrit.server.project.ProjectCache;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;

class LdapGroupMembership
implements GroupMembership {
    private final LoadingCache<String, Set<AccountGroup.UUID>> membershipCache;
    private final ProjectCache projectCache;
    private final String id;
    private GroupMembership membership;

    LdapGroupMembership(LoadingCache<String, Set<AccountGroup.UUID>> membershipCache, ProjectCache projectCache, String id) {
        this.membershipCache = membershipCache;
        this.projectCache = projectCache;
        this.id = id;
    }

    @Override
    public boolean contains(AccountGroup.UUID groupId) {
        return this.get().contains(groupId);
    }

    @Override
    public boolean containsAnyOf(Iterable<AccountGroup.UUID> groupIds) {
        return this.get().containsAnyOf(groupIds);
    }

    @Override
    public Set<AccountGroup.UUID> intersection(Iterable<AccountGroup.UUID> groupIds) {
        return this.get().intersection(groupIds);
    }

    @Override
    public Set<AccountGroup.UUID> getKnownGroups() {
        HashSet<AccountGroup.UUID> g = new HashSet<AccountGroup.UUID>(this.get().getKnownGroups());
        g.retainAll(this.projectCache.guessRelevantGroupUUIDs());
        return g;
    }

    private synchronized GroupMembership get() {
        if (this.membership == null) {
            try {
                this.membership = new ListGroupMembership((Iterable<AccountGroup.UUID>)this.membershipCache.get(this.id));
            }
            catch (ExecutionException e) {
                LdapGroupBackend.log.warn("Cannot lookup membershipsOf {} in LDAP", (Object)this.id, (Object)e);
                this.membership = GroupMembership.EMPTY;
            }
        }
        return this.membership;
    }
}

