/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.conditions.BooleanCondition;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.DeletePrivate;
import com.google.gerrit.server.change.SetPrivateOp;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.update.RetryHelper;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
public class DeletePrivateByPost
extends DeletePrivate
implements UiAction<ChangeResource> {
    @Inject
    DeletePrivateByPost(Provider<ReviewDb> dbProvider, RetryHelper retryHelper, ChangeMessagesUtil cmUtil, PermissionBackend permissionBackend, SetPrivateOp.Factory setPrivateOpFactory) {
        super(dbProvider, retryHelper, cmUtil, permissionBackend, setPrivateOpFactory);
    }

    @Override
    public UiAction.Description getDescription(ChangeResource rsrc) {
        return new UiAction.Description().setLabel("Unmark private").setTitle("Unmark change as private").setVisible(BooleanCondition.and(rsrc.getChange().isPrivate(), this.canDeletePrivate(rsrc)));
    }
}

