/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.Iterables;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.extensions.api.changes.DeleteReviewerInput;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.reviewdb.server.ReviewDbUtil;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.change.DeleteReviewer;
import com.google.gerrit.server.change.NotifyUtil;
import com.google.gerrit.server.extensions.events.ReviewerDeleted;
import com.google.gerrit.server.mail.send.DeleteReviewerSender;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.NoteDbChangeState;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.RemoveReviewerControl;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.BatchUpdateReviewDb;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteReviewerOp
implements BatchUpdateOp {
    private static final Logger log = LoggerFactory.getLogger(DeleteReviewer.class);
    private final ApprovalsUtil approvalsUtil;
    private final PatchSetUtil psUtil;
    private final ChangeMessagesUtil cmUtil;
    private final IdentifiedUser.GenericFactory userFactory;
    private final ReviewerDeleted reviewerDeleted;
    private final Provider<IdentifiedUser> user;
    private final DeleteReviewerSender.Factory deleteReviewerSenderFactory;
    private final NotesMigration migration;
    private final NotifyUtil notifyUtil;
    private final RemoveReviewerControl removeReviewerControl;
    private final ProjectCache projectCache;
    private final Account reviewer;
    private final DeleteReviewerInput input;
    ChangeMessage changeMessage;
    Change currChange;
    PatchSet currPs;
    Map<String, Short> newApprovals = new HashMap<String, Short>();
    Map<String, Short> oldApprovals = new HashMap<String, Short>();

    @Inject
    DeleteReviewerOp(ApprovalsUtil approvalsUtil, PatchSetUtil psUtil, ChangeMessagesUtil cmUtil, IdentifiedUser.GenericFactory userFactory, ReviewerDeleted reviewerDeleted, Provider<IdentifiedUser> user, DeleteReviewerSender.Factory deleteReviewerSenderFactory, NotesMigration migration, NotifyUtil notifyUtil, RemoveReviewerControl removeReviewerControl, ProjectCache projectCache, @Assisted Account reviewerAccount, @Assisted DeleteReviewerInput input) {
        this.approvalsUtil = approvalsUtil;
        this.psUtil = psUtil;
        this.cmUtil = cmUtil;
        this.userFactory = userFactory;
        this.reviewerDeleted = reviewerDeleted;
        this.user = user;
        this.deleteReviewerSenderFactory = deleteReviewerSenderFactory;
        this.migration = migration;
        this.notifyUtil = notifyUtil;
        this.removeReviewerControl = removeReviewerControl;
        this.projectCache = projectCache;
        this.reviewer = reviewerAccount;
        this.input = input;
    }

    @Override
    public boolean updateChange(ChangeContext ctx) throws AuthException, ResourceNotFoundException, OrmException, PermissionBackendException, IOException, NoSuchProjectException {
        Account.Id reviewerId = this.reviewer.getId();
        this.removeReviewerControl.checkRemoveReviewer(ctx.getNotes(), ctx.getUser(), reviewerId);
        if (!this.approvalsUtil.getReviewers(ctx.getDb(), ctx.getNotes()).all().contains(reviewerId)) {
            throw new ResourceNotFoundException();
        }
        this.currChange = ctx.getChange();
        this.currPs = this.psUtil.current(ctx.getDb(), ctx.getNotes());
        LabelTypes labelTypes = this.projectCache.checkedGet(ctx.getProject()).getLabelTypes(ctx.getNotes(), ctx.getUser());
        for (LabelType lt : labelTypes.getLabelTypes()) {
            this.newApprovals.put(lt.getName(), (short)0);
        }
        StringBuilder msg = new StringBuilder();
        msg.append("Removed reviewer " + this.reviewer.getFullName());
        StringBuilder removedVotesMsg = new StringBuilder();
        removedVotesMsg.append(" with the following votes:\n\n");
        ArrayList<PatchSetApproval> del = new ArrayList<PatchSetApproval>();
        boolean votesRemoved = false;
        for (PatchSetApproval a : this.approvals(ctx, reviewerId)) {
            this.removeReviewerControl.checkRemoveReviewer(ctx.getNotes(), ctx.getUser(), a);
            del.add(a);
            if (!a.getPatchSetId().equals(this.currPs.getId()) || a.getValue() == 0) continue;
            this.oldApprovals.put(a.getLabel(), a.getValue());
            removedVotesMsg.append("* ").append(a.getLabel()).append(this.formatLabelValue(a.getValue())).append(" by ").append(this.userFactory.create(a.getAccountId()).getNameEmail()).append("\n");
            votesRemoved = true;
        }
        if (votesRemoved) {
            msg.append((CharSequence)removedVotesMsg);
        } else {
            msg.append(".");
        }
        ctx.getDb().patchSetApprovals().delete(del);
        ChangeUpdate update = ctx.getUpdate(this.currPs.getId());
        update.removeReviewer(reviewerId);
        this.changeMessage = ChangeMessagesUtil.newMessage(ctx, msg.toString(), "autogenerated:gerrit:deleteReviewer");
        this.cmUtil.addChangeMessage(ctx.getDb(), update, this.changeMessage);
        return true;
    }

    @Override
    public void postUpdate(Context ctx) {
        if (this.input.notify == null) {
            this.input.notify = this.currChange.isWorkInProgress() ? (this.oldApprovals.isEmpty() ? NotifyHandling.NONE : NotifyHandling.OWNER) : NotifyHandling.ALL;
        }
        if (NotifyUtil.shouldNotify(this.input.notify, this.input.notifyDetails)) {
            this.emailReviewers(ctx.getProject(), this.currChange, this.changeMessage);
        }
        this.reviewerDeleted.fire(this.currChange, this.currPs, this.reviewer, ctx.getAccount(), this.changeMessage.getMessage(), this.newApprovals, this.oldApprovals, this.input.notify, ctx.getWhen());
    }

    private Iterable<PatchSetApproval> approvals(ChangeContext ctx, Account.Id accountId) throws OrmException {
        Iterable<Object> approvals;
        Change.Id changeId = ctx.getNotes().getChangeId();
        NoteDbChangeState.PrimaryStorage r = NoteDbChangeState.PrimaryStorage.of(ctx.getChange());
        if (this.migration.readChanges() && r == NoteDbChangeState.PrimaryStorage.REVIEW_DB) {
            ReviewDb db = ctx.getDb();
            if (db instanceof BatchUpdateReviewDb) {
                db = ((BatchUpdateReviewDb)db).unsafeGetDelegate();
            }
            db = ReviewDbUtil.unwrapDb(db);
            approvals = db.patchSetApprovals().byChange(changeId);
        } else {
            approvals = this.approvalsUtil.byChange(ctx.getDb(), ctx.getNotes()).values();
        }
        return Iterables.filter(approvals, psa -> accountId.equals(psa.getAccountId()));
    }

    private String formatLabelValue(short value) {
        if (value > 0) {
            return "+" + value;
        }
        return Short.toString(value);
    }

    private void emailReviewers(Project.NameKey projectName, Change change, ChangeMessage changeMessage) {
        Account.Id userId = this.user.get().getAccountId();
        if (userId.equals(this.reviewer.getId())) {
            return;
        }
        try {
            DeleteReviewerSender cm = this.deleteReviewerSenderFactory.create(projectName, change.getId());
            cm.setFrom(userId);
            cm.addReviewers(Collections.singleton(this.reviewer.getId()));
            cm.setChangeMessage(changeMessage.getMessage(), changeMessage.getWrittenOn());
            cm.setNotify(this.input.notify);
            cm.setAccountsToNotify(this.notifyUtil.resolveAccounts(this.input.notifyDetails));
            cm.send();
        }
        catch (Exception err) {
            log.error("Cannot email update for change " + change.getId(), err);
        }
    }

    public static interface Factory {
        public DeleteReviewerOp create(Account var1, DeleteReviewerInput var2);
    }
}

