/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.Weigher;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.gerrit.extensions.client.SubmitType;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gerrit.server.change.MergeabilityCache;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.strategy.SubmitDryRun;
import com.google.gerrit.server.ioutil.BasicSerialization;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSerialization;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MergeabilityCacheImpl
implements MergeabilityCache {
    private static final Logger log = LoggerFactory.getLogger(MergeabilityCacheImpl.class);
    private static final String CACHE_NAME = "mergeability";
    public static final ImmutableBiMap<SubmitType, Character> SUBMIT_TYPES = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)new ImmutableBiMap.Builder().put((Object)SubmitType.FAST_FORWARD_ONLY, Character.valueOf('F'))).put((Object)SubmitType.MERGE_IF_NECESSARY, Character.valueOf('M'))).put((Object)SubmitType.REBASE_ALWAYS, Character.valueOf('P'))).put((Object)SubmitType.REBASE_IF_NECESSARY, Character.valueOf('R'))).put((Object)SubmitType.MERGE_ALWAYS, Character.valueOf('A'))).put((Object)SubmitType.CHERRY_PICK, Character.valueOf('C'))).build();
    private final SubmitDryRun submitDryRun;
    private final Cache<EntryKey, Boolean> cache;

    public static Module module() {
        return new CacheModule(){

            @Override
            protected void configure() {
                this.persist(MergeabilityCacheImpl.CACHE_NAME, EntryKey.class, Boolean.class).maximumWeight(0x100000L).weigher(MergeabilityWeigher.class);
                this.bind(MergeabilityCache.class).to(MergeabilityCacheImpl.class);
            }
        };
    }

    public static ObjectId toId(Ref ref) {
        return ref != null && ref.getObjectId() != null ? ref.getObjectId() : ObjectId.zeroId();
    }

    @Inject
    MergeabilityCacheImpl(SubmitDryRun submitDryRun, @Named(value="mergeability") Cache<EntryKey, Boolean> cache) {
        this.submitDryRun = submitDryRun;
        this.cache = cache;
    }

    @Override
    public boolean get(ObjectId commit, Ref intoRef, SubmitType submitType, String mergeStrategy, Branch.NameKey dest, Repository repo) {
        ObjectId into = intoRef != null ? intoRef.getObjectId() : ObjectId.zeroId();
        EntryKey key = new EntryKey(commit, into, submitType, mergeStrategy);
        try {
            return this.cache.get(key, () -> {
                if (key.into.equals(ObjectId.zeroId())) {
                    return true;
                }
                try (CodeReviewCommit.CodeReviewRevWalk rw = CodeReviewCommit.newRevWalk(repo);){
                    Set<RevCommit> accepted = SubmitDryRun.getAlreadyAccepted(repo, rw);
                    accepted.add(rw.parseCommit(key.into));
                    accepted.addAll(Arrays.asList(rw.parseCommit(key.commit).getParents()));
                    Boolean bl = this.submitDryRun.run(key.submitType, repo, rw, dest, key.into, key.commit, accepted);
                    return bl;
                }
            });
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            log.error("Error checking mergeability of {} into {} ({})", key.commit.name(), key.into.name(), key.submitType.name(), e.getCause());
            return false;
        }
    }

    @Override
    public Boolean getIfPresent(ObjectId commit, Ref intoRef, SubmitType submitType, String mergeStrategy) {
        return this.cache.getIfPresent(new EntryKey(commit, MergeabilityCacheImpl.toId(intoRef), submitType, mergeStrategy));
    }

    static {
        Preconditions.checkState(SUBMIT_TYPES.size() == SubmitType.values().length, "SubmitType <-> char BiMap needs updating");
    }

    public static class MergeabilityWeigher
    implements Weigher<EntryKey, Boolean> {
        @Override
        public int weigh(EntryKey k, Boolean v) {
            return 120;
        }
    }

    public static class EntryKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private ObjectId commit;
        private ObjectId into;
        private SubmitType submitType;
        private String mergeStrategy;

        public EntryKey(ObjectId commit, ObjectId into, SubmitType submitType, String mergeStrategy) {
            this.commit = Preconditions.checkNotNull(commit, "commit");
            this.into = Preconditions.checkNotNull(into, "into");
            this.submitType = Preconditions.checkNotNull(submitType, "submitType");
            this.mergeStrategy = Preconditions.checkNotNull(mergeStrategy, "mergeStrategy");
        }

        public ObjectId getCommit() {
            return this.commit;
        }

        public ObjectId getInto() {
            return this.into;
        }

        public SubmitType getSubmitType() {
            return this.submitType;
        }

        public String getMergeStrategy() {
            return this.mergeStrategy;
        }

        public boolean equals(Object o) {
            if (o instanceof EntryKey) {
                EntryKey k = (EntryKey)o;
                return this.commit.equals(k.commit) && this.into.equals(k.into) && this.submitType == k.submitType && this.mergeStrategy.equals(k.mergeStrategy);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.commit, this.into, this.submitType, this.mergeStrategy});
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("commit", this.commit.name()).add("into", this.into.name()).addValue((Object)this.submitType).addValue(this.mergeStrategy).toString();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            ObjectIdSerialization.writeNotNull(out, this.commit);
            ObjectIdSerialization.writeNotNull(out, this.into);
            Character c = (Character)SUBMIT_TYPES.get((Object)this.submitType);
            if (c == null) {
                throw new IOException("Invalid submit type: " + (Object)((Object)this.submitType));
            }
            out.writeChar(c.charValue());
            BasicSerialization.writeString(out, this.mergeStrategy);
        }

        private void readObject(ObjectInputStream in) throws IOException {
            this.commit = ObjectIdSerialization.readNotNull(in);
            this.into = ObjectIdSerialization.readNotNull(in);
            char t = in.readChar();
            this.submitType = (SubmitType)((Object)((ImmutableMap)((Object)SUBMIT_TYPES.inverse())).get(Character.valueOf(t)));
            if (this.submitType == null) {
                throw new IOException("Invalid submit type code: " + t);
            }
            this.mergeStrategy = BasicSerialization.readString(in);
        }
    }
}

