/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.extensions.conditions.BooleanCondition;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.SetPrivateOp;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.RetryHelper;
import com.google.gerrit.server.update.RetryingRestModifyView;
import com.google.gerrit.server.update.UpdateException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import org.eclipse.jgit.lib.Config;

@Singleton
public class PostPrivate
extends RetryingRestModifyView<ChangeResource, SetPrivateOp.Input, Response<String>>
implements UiAction<ChangeResource> {
    private final ChangeMessagesUtil cmUtil;
    private final Provider<ReviewDb> dbProvider;
    private final PermissionBackend permissionBackend;
    private final SetPrivateOp.Factory setPrivateOpFactory;
    private final boolean disablePrivateChanges;

    @Inject
    PostPrivate(Provider<ReviewDb> dbProvider, RetryHelper retryHelper, ChangeMessagesUtil cmUtil, PermissionBackend permissionBackend, SetPrivateOp.Factory setPrivateOpFactory, @GerritServerConfig Config config) {
        super(retryHelper);
        this.dbProvider = dbProvider;
        this.cmUtil = cmUtil;
        this.permissionBackend = permissionBackend;
        this.setPrivateOpFactory = setPrivateOpFactory;
        this.disablePrivateChanges = config.getBoolean("change", null, "disablePrivateChanges", false);
    }

    @Override
    public Response<String> applyImpl(BatchUpdate.Factory updateFactory, ChangeResource rsrc, SetPrivateOp.Input input) throws RestApiException, UpdateException {
        if (this.disablePrivateChanges) {
            throw new MethodNotAllowedException("private changes are disabled");
        }
        if (!this.canSetPrivate(rsrc).value()) {
            throw new AuthException("not allowed to mark private");
        }
        if (rsrc.getChange().isPrivate()) {
            return Response.ok("");
        }
        SetPrivateOp op = this.setPrivateOpFactory.create(this.cmUtil, true, input);
        try (BatchUpdate u = updateFactory.create(this.dbProvider.get(), rsrc.getProject(), rsrc.getUser(), TimeUtil.nowTs());){
            u.addOp(rsrc.getId(), op).execute();
        }
        return Response.created("");
    }

    @Override
    public UiAction.Description getDescription(ChangeResource rsrc) {
        Change change = rsrc.getChange();
        return new UiAction.Description().setLabel("Mark private").setTitle("Mark change as private").setVisible(BooleanCondition.and(!this.disablePrivateChanges && !change.isPrivate(), this.canSetPrivate(rsrc)));
    }

    private BooleanCondition canSetPrivate(ChangeResource rsrc) {
        PermissionBackend.WithUser user = this.permissionBackend.user(rsrc.getUser());
        return BooleanCondition.or(rsrc.isUserOwner() && rsrc.getChange().getStatus() != Change.Status.MERGED, user.testCond(GlobalPermission.ADMINISTRATE_SERVER));
    }
}

