/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.api.changes.AddReviewerInput;
import com.google.gerrit.extensions.api.changes.AddReviewerResult;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.extensions.api.changes.ReviewerInfo;
import com.google.gerrit.extensions.client.ReviewerState;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.AnonymousUser;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountLoader;
import com.google.gerrit.server.account.AccountsCollection;
import com.google.gerrit.server.account.GroupMembers;
import com.google.gerrit.server.change.ChangeMessages;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.NotifyUtil;
import com.google.gerrit.server.change.PostReviewersOp;
import com.google.gerrit.server.change.ReviewerJson;
import com.google.gerrit.server.change.ReviewerResource;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.group.GroupsCollection;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.gerrit.server.mail.Address;
import com.google.gerrit.server.mail.send.OutgoingEmailValidator;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.permissions.ChangePermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.RefPermission;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.RetryHelper;
import com.google.gerrit.server.update.RetryingRestModifyView;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;

@Singleton
public class PostReviewers
extends RetryingRestModifyView<ChangeResource, AddReviewerInput, AddReviewerResult> {
    public static final int DEFAULT_MAX_REVIEWERS_WITHOUT_CHECK = 10;
    public static final int DEFAULT_MAX_REVIEWERS = 20;
    private final AccountsCollection accounts;
    private final ReviewerResource.Factory reviewerFactory;
    private final PermissionBackend permissionBackend;
    private final GroupsCollection groupsCollection;
    private final GroupMembers.Factory groupMembersFactory;
    private final AccountLoader.Factory accountLoaderFactory;
    private final Provider<ReviewDb> dbProvider;
    private final ChangeData.Factory changeDataFactory;
    private final IdentifiedUser.GenericFactory identifiedUserFactory;
    private final Config cfg;
    private final ReviewerJson json;
    private final NotesMigration migration;
    private final NotifyUtil notifyUtil;
    private final ProjectCache projectCache;
    private final Provider<AnonymousUser> anonymousProvider;
    private final PostReviewersOp.Factory postReviewersOpFactory;
    private final OutgoingEmailValidator validator;

    @Inject
    PostReviewers(AccountsCollection accounts, ReviewerResource.Factory reviewerFactory, PermissionBackend permissionBackend, GroupsCollection groupsCollection, GroupMembers.Factory groupMembersFactory, AccountLoader.Factory accountLoaderFactory, Provider<ReviewDb> db, ChangeData.Factory changeDataFactory, RetryHelper retryHelper, IdentifiedUser.GenericFactory identifiedUserFactory, @GerritServerConfig Config cfg, ReviewerJson json, NotesMigration migration, NotifyUtil notifyUtil, ProjectCache projectCache, Provider<AnonymousUser> anonymousProvider, PostReviewersOp.Factory postReviewersOpFactory, OutgoingEmailValidator validator) {
        super(retryHelper);
        this.accounts = accounts;
        this.reviewerFactory = reviewerFactory;
        this.permissionBackend = permissionBackend;
        this.groupsCollection = groupsCollection;
        this.groupMembersFactory = groupMembersFactory;
        this.accountLoaderFactory = accountLoaderFactory;
        this.dbProvider = db;
        this.changeDataFactory = changeDataFactory;
        this.identifiedUserFactory = identifiedUserFactory;
        this.cfg = cfg;
        this.json = json;
        this.migration = migration;
        this.notifyUtil = notifyUtil;
        this.projectCache = projectCache;
        this.anonymousProvider = anonymousProvider;
        this.postReviewersOpFactory = postReviewersOpFactory;
        this.validator = validator;
    }

    @Override
    protected AddReviewerResult applyImpl(BatchUpdate.Factory updateFactory, ChangeResource rsrc, AddReviewerInput input) throws IOException, OrmException, RestApiException, UpdateException, PermissionBackendException, ConfigInvalidException {
        if (input.reviewer == null) {
            throw new BadRequestException("missing reviewer field");
        }
        Addition addition = this.prepareApplication(rsrc, input, true);
        if (addition.op == null) {
            return addition.result;
        }
        try (BatchUpdate bu = updateFactory.create(this.dbProvider.get(), rsrc.getProject(), rsrc.getUser(), TimeUtil.nowTs());){
            Change.Id id = rsrc.getChange().getId();
            bu.addOp(id, addition.op);
            bu.execute();
            addition.gatherResults();
        }
        return addition.result;
    }

    public Addition prepareApplication(ChangeResource rsrc, AddReviewerInput input, boolean allowGroup) throws OrmException, IOException, PermissionBackendException, ConfigInvalidException {
        String reviewer = input.reviewer;
        ReviewerState state = input.state();
        NotifyHandling notify = input.notify;
        ListMultimap<RecipientType, Account.Id> accountsToNotify = null;
        try {
            accountsToNotify = this.notifyUtil.resolveAccounts(input.notifyDetails);
        }
        catch (BadRequestException e) {
            return this.fail(reviewer, e.getMessage());
        }
        boolean confirmed = input.confirmed();
        boolean allowByEmail = this.projectCache.checkedGet(rsrc.getProject()).isEnableReviewerByEmail();
        Addition byAccountId = this.addByAccountId(reviewer, rsrc, state, notify, accountsToNotify, allowGroup, allowByEmail);
        Addition wholeGroup = null;
        if ((byAccountId == null || !byAccountId.exactMatchFound) && (wholeGroup = this.addWholeGroup(reviewer, rsrc, state, notify, accountsToNotify, confirmed, allowGroup, allowByEmail)) != null && wholeGroup.exactMatchFound) {
            return wholeGroup;
        }
        if (byAccountId != null) {
            return byAccountId;
        }
        if (wholeGroup != null) {
            return wholeGroup;
        }
        return this.addByEmail(reviewer, rsrc, state, notify, accountsToNotify);
    }

    Addition ccCurrentUser(CurrentUser user, RevisionResource revision) {
        return new Addition(user.getUserName(), revision.getChangeResource(), ImmutableSet.of(user.getAccountId()), null, ReviewerState.CC, NotifyHandling.NONE, ImmutableListMultimap.of(), true);
    }

    @Nullable
    private Addition addByAccountId(String reviewer, ChangeResource rsrc, ReviewerState state, NotifyHandling notify, ListMultimap<RecipientType, Account.Id> accountsToNotify, boolean allowGroup, boolean allowByEmail) throws OrmException, PermissionBackendException, IOException, ConfigInvalidException {
        IdentifiedUser user = null;
        boolean exactMatchFound = false;
        try {
            user = this.accounts.parse(reviewer);
            if (reviewer.equalsIgnoreCase(user.getName()) || reviewer.equals(String.valueOf(user.getAccountId()))) {
                exactMatchFound = true;
            }
        }
        catch (AuthException | UnprocessableEntityException e) {
            if (!allowGroup && !allowByEmail) {
                return this.fail(reviewer, MessageFormat.format(ChangeMessages.get().reviewerNotFoundUser, reviewer));
            }
            return null;
        }
        ReviewerResource rrsrc = this.reviewerFactory.create(rsrc, user.getAccountId());
        Account member = rrsrc.getReviewerUser().getAccount();
        PermissionBackend.ForRef perm = this.permissionBackend.user(rrsrc.getReviewerUser()).ref(rrsrc.getChange().getDest());
        if (this.isValidReviewer(member, perm)) {
            return new Addition(reviewer, rsrc, ImmutableSet.of(member.getId()), null, state, notify, accountsToNotify, exactMatchFound);
        }
        if (!member.isActive()) {
            if (allowByEmail && state == ReviewerState.CC) {
                return null;
            }
            return this.fail(reviewer, MessageFormat.format(ChangeMessages.get().reviewerInactive, reviewer));
        }
        return this.fail(reviewer, MessageFormat.format(ChangeMessages.get().reviewerCantSeeChange, reviewer));
    }

    @Nullable
    private Addition addWholeGroup(String reviewer, ChangeResource rsrc, ReviewerState state, NotifyHandling notify, ListMultimap<RecipientType, Account.Id> accountsToNotify, boolean confirmed, boolean allowGroup, boolean allowByEmail) throws OrmException, IOException, PermissionBackendException {
        Set<Account> members;
        if (!allowGroup) {
            return null;
        }
        GroupDescription.Internal group = null;
        try {
            group = this.groupsCollection.parseInternal(reviewer);
        }
        catch (UnprocessableEntityException e) {
            if (!allowByEmail) {
                return this.fail(reviewer, MessageFormat.format(ChangeMessages.get().reviewerNotFoundUserOrGroup, reviewer));
            }
            return null;
        }
        if (!PostReviewers.isLegalReviewerGroup(group.getGroupUUID())) {
            return this.fail(reviewer, MessageFormat.format(ChangeMessages.get().groupIsNotAllowed, group.getName()));
        }
        HashSet<Account.Id> reviewers = new HashSet<Account.Id>();
        try {
            members = this.groupMembersFactory.create(rsrc.getUser()).listAccounts(group.getGroupUUID(), rsrc.getProject());
        }
        catch (NoSuchGroupException e) {
            return this.fail(reviewer, MessageFormat.format(ChangeMessages.get().reviewerNotFoundUserOrGroup, group.getName()));
        }
        catch (NoSuchProjectException e) {
            return this.fail(reviewer, e.getMessage());
        }
        int maxAllowed = this.cfg.getInt("addreviewer", "maxAllowed", 20);
        if (maxAllowed > 0 && members.size() > maxAllowed) {
            return this.fail(reviewer, MessageFormat.format(ChangeMessages.get().groupHasTooManyMembers, group.getName()));
        }
        int maxWithoutConfirmation = this.cfg.getInt("addreviewer", "maxWithoutConfirmation", 10);
        if (!confirmed && maxWithoutConfirmation > 0 && members.size() > maxWithoutConfirmation) {
            return this.fail(reviewer, true, MessageFormat.format(ChangeMessages.get().groupManyMembersConfirmation, group.getName(), members.size()));
        }
        PermissionBackend.ForRef perm = this.permissionBackend.user(rsrc.getUser()).ref(rsrc.getChange().getDest());
        for (Account member : members) {
            if (!this.isValidReviewer(member, perm)) continue;
            reviewers.add(member.getId());
        }
        return new Addition(reviewer, rsrc, reviewers, null, state, notify, accountsToNotify, true);
    }

    @Nullable
    private Addition addByEmail(String reviewer, ChangeResource rsrc, ReviewerState state, NotifyHandling notify, ListMultimap<RecipientType, Account.Id> accountsToNotify) throws PermissionBackendException {
        if (!((PermissionBackend.ForChange)this.permissionBackend.user(this.anonymousProvider).change(rsrc.getNotes()).database(this.dbProvider)).test(ChangePermission.READ)) {
            return this.fail(reviewer, MessageFormat.format(ChangeMessages.get().reviewerCantSeeChange, reviewer));
        }
        if (!this.migration.readChanges()) {
            return this.fail(reviewer, MessageFormat.format(ChangeMessages.get().reviewerNotFoundUser, reviewer));
        }
        Address adr = Address.tryParse(reviewer);
        if (adr == null || !this.validator.isValid(adr.getEmail())) {
            return this.fail(reviewer, MessageFormat.format(ChangeMessages.get().reviewerInvalid, reviewer));
        }
        return new Addition(reviewer, rsrc, null, ImmutableList.of(adr), state, notify, accountsToNotify, true);
    }

    private boolean isValidReviewer(Account member, PermissionBackend.ForRef perm) throws PermissionBackendException {
        if (member.isActive()) {
            IdentifiedUser user = this.identifiedUserFactory.create(member.getId());
            try {
                perm.user(user).check(RefPermission.READ);
                return true;
            }
            catch (AuthException e) {
                return false;
            }
        }
        return false;
    }

    private Addition fail(String reviewer, String error) {
        return this.fail(reviewer, false, error);
    }

    private Addition fail(String reviewer, boolean confirm, String error) {
        Addition addition = new Addition(reviewer);
        addition.result.confirm = confirm ? Boolean.valueOf(true) : null;
        addition.result.error = error;
        return addition;
    }

    public static boolean isLegalReviewerGroup(AccountGroup.UUID groupUUID) {
        return !SystemGroupBackend.isSystemGroup(groupUUID);
    }

    public class Addition {
        final AddReviewerResult result;
        final PostReviewersOp op;
        final Set<Account.Id> reviewers;
        final Collection<Address> reviewersByEmail;
        final ReviewerState state;
        final ChangeNotes notes;
        final IdentifiedUser caller;
        final boolean exactMatchFound;

        Addition(String reviewer) {
            this.result = new AddReviewerResult(reviewer);
            this.op = null;
            this.reviewers = ImmutableSet.of();
            this.reviewersByEmail = ImmutableSet.of();
            this.state = ReviewerState.REVIEWER;
            this.notes = null;
            this.caller = null;
            this.exactMatchFound = false;
        }

        protected Addition(String reviewer, @Nullable ChangeResource rsrc, @Nullable Set<Account.Id> reviewers, Collection<Address> reviewersByEmail, @Nullable ReviewerState state, NotifyHandling notify, ListMultimap<RecipientType, Account.Id> accountsToNotify, boolean exactMatchFound) {
            Preconditions.checkArgument(reviewers != null || reviewersByEmail != null, "must have either reviewers or reviewersByEmail");
            this.result = new AddReviewerResult(reviewer);
            this.reviewers = reviewers == null ? ImmutableSet.of() : reviewers;
            this.reviewersByEmail = reviewersByEmail == null ? ImmutableList.of() : reviewersByEmail;
            this.state = state;
            this.notes = rsrc.getNotes();
            this.caller = rsrc.getUser().asIdentifiedUser();
            this.op = PostReviewers.this.postReviewersOpFactory.create(rsrc, this.reviewers, this.reviewersByEmail, state, notify, accountsToNotify);
            this.exactMatchFound = exactMatchFound;
        }

        void gatherResults() throws OrmException, PermissionBackendException {
            if (this.notes == null || this.caller == null) {
                return;
            }
            ChangeData cd = PostReviewers.this.changeDataFactory.create((ReviewDb)PostReviewers.this.dbProvider.get(), this.notes);
            PermissionBackend.ForChange perm = ((PermissionBackend.WithUser)PostReviewers.this.permissionBackend.user(this.caller).database(PostReviewers.this.dbProvider)).change(cd);
            PostReviewersOp.Result opResult = this.op.getResult();
            if (PostReviewers.this.migration.readChanges() && this.state == ReviewerState.CC) {
                this.result.ccs = Lists.newArrayListWithCapacity(opResult.addedCCs().size());
                for (Account.Id accountId : opResult.addedCCs()) {
                    IdentifiedUser u = PostReviewers.this.identifiedUserFactory.create(accountId);
                    this.result.ccs.add(PostReviewers.this.json.format(this.caller, new ReviewerInfo(accountId.get()), perm.user(u), cd));
                }
                PostReviewers.this.accountLoaderFactory.create(true).fill(this.result.ccs);
                for (Address a : this.reviewersByEmail) {
                    this.result.ccs.add(new AccountInfo(a.getName(), a.getEmail()));
                }
            } else {
                this.result.reviewers = Lists.newArrayListWithCapacity(opResult.addedReviewers().size());
                for (PatchSetApproval psa : opResult.addedReviewers()) {
                    IdentifiedUser u = PostReviewers.this.identifiedUserFactory.create(psa.getAccountId());
                    this.result.reviewers.add(PostReviewers.this.json.format(this.caller, new ReviewerInfo(psa.getAccountId().get()), perm.user(u), cd, ImmutableList.of(psa)));
                }
                PostReviewers.this.accountLoaderFactory.create(true).fill(this.result.reviewers);
                for (Address a : this.reviewersByEmail) {
                    this.result.reviewers.add(ReviewerInfo.byEmail(a.getName(), a.getEmail()));
                }
            }
        }
    }
}

