/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.server.change.AccountPatchReviewStore;
import com.google.gerrit.server.change.FileResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;

public class Reviewed {
    private Reviewed() {
    }

    @Singleton
    public static class DeleteReviewed
    implements RestModifyView<FileResource, Input> {
        private final DynamicItem<AccountPatchReviewStore> accountPatchReviewStore;

        @Inject
        DeleteReviewed(DynamicItem<AccountPatchReviewStore> accountPatchReviewStore) {
            this.accountPatchReviewStore = accountPatchReviewStore;
        }

        public Response<?> apply(FileResource resource, Input input) throws OrmException {
            this.accountPatchReviewStore.get().clearReviewed(resource.getPatchKey().getParentKey(), resource.getAccountId(), resource.getPatchKey().getFileName());
            return Response.none();
        }
    }

    @Singleton
    public static class PutReviewed
    implements RestModifyView<FileResource, Input> {
        private final DynamicItem<AccountPatchReviewStore> accountPatchReviewStore;

        @Inject
        PutReviewed(DynamicItem<AccountPatchReviewStore> accountPatchReviewStore) {
            this.accountPatchReviewStore = accountPatchReviewStore;
        }

        public Response<String> apply(FileResource resource, Input input) throws OrmException {
            if (this.accountPatchReviewStore.get().markReviewed(resource.getPatchKey().getParentKey(), resource.getAccountId(), resource.getPatchKey().getFileName())) {
                return Response.created("");
            }
            return Response.ok("");
        }
    }

    public static class Input {
    }
}

