/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.change.EmailReviewComments;
import com.google.gerrit.server.extensions.events.WorkInProgressStateChanged;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;

public class WorkInProgressOp
implements BatchUpdateOp {
    private final ChangeMessagesUtil cmUtil;
    private final EmailReviewComments.Factory email;
    private final PatchSetUtil psUtil;
    private final boolean workInProgress;
    private final Input in;
    private final NotifyHandling notify;
    private final WorkInProgressStateChanged stateChanged;
    private Change change;
    private ChangeNotes notes;
    private PatchSet ps;
    private ChangeMessage cmsg;

    @Inject
    WorkInProgressOp(ChangeMessagesUtil cmUtil, EmailReviewComments.Factory email, PatchSetUtil psUtil, WorkInProgressStateChanged stateChanged, @Assisted boolean workInProgress, @Assisted Input in) {
        this.cmUtil = cmUtil;
        this.email = email;
        this.psUtil = psUtil;
        this.stateChanged = stateChanged;
        this.workInProgress = workInProgress;
        this.in = in;
        this.notify = MoreObjects.firstNonNull(in.notify, workInProgress ? NotifyHandling.NONE : NotifyHandling.ALL);
    }

    @Override
    public boolean updateChange(ChangeContext ctx) throws OrmException {
        this.change = ctx.getChange();
        this.notes = ctx.getNotes();
        this.ps = this.psUtil.get(ctx.getDb(), ctx.getNotes(), this.change.currentPatchSetId());
        ChangeUpdate update = ctx.getUpdate(this.change.currentPatchSetId());
        this.change.setWorkInProgress(this.workInProgress);
        if (!this.change.hasReviewStarted() && !this.workInProgress) {
            this.change.setReviewStarted(true);
        }
        this.change.setLastUpdatedOn(ctx.getWhen());
        update.setWorkInProgress(this.workInProgress);
        this.addMessage(ctx, update);
        return true;
    }

    private void addMessage(ChangeContext ctx, ChangeUpdate update) throws OrmException {
        Change c = ctx.getChange();
        StringBuilder buf = new StringBuilder(c.isWorkInProgress() ? "Set Work In Progress" : "Set Ready For Review");
        String m = Strings.nullToEmpty(this.in == null ? null : this.in.message).trim();
        if (!m.isEmpty()) {
            buf.append("\n\n");
            buf.append(m);
        }
        this.cmsg = ChangeMessagesUtil.newMessage(ctx, buf.toString(), c.isWorkInProgress() ? "autogenerated:gerrit:setWorkInProgress" : "autogenerated:gerrit:setReadyForReview");
        this.cmUtil.addChangeMessage(ctx.getDb(), update, this.cmsg);
    }

    @Override
    public void postUpdate(Context ctx) {
        this.stateChanged.fire(this.change, this.ps, ctx.getAccount(), ctx.getWhen());
        if (this.workInProgress || this.notify.ordinal() < NotifyHandling.OWNER_REVIEWERS.ordinal()) {
            return;
        }
        this.email.create(this.notify, ImmutableListMultimap.of(), this.notes, this.ps, ctx.getIdentifiedUser(), this.cmsg, ImmutableList.of(), this.cmsg.getMessage(), ImmutableList.of()).sendAsync();
    }

    public static interface Factory {
        public WorkInProgressOp create(boolean var1, Input var2);
    }

    public static class Input {
        @Nullable
        String message;
        @Nullable
        NotifyHandling notify;

        public Input() {
        }

        public Input(String message) {
            this.message = message;
        }
    }
}

