/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.extensions.events;

import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.RevisionInfo;
import com.google.gerrit.extensions.events.ChangeMergedListener;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.GpgException;
import com.google.gerrit.server.extensions.events.AbstractRevisionEvent;
import com.google.gerrit.server.extensions.events.EventUtil;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.patch.PatchListObjectTooLargeException;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.sql.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ChangeMerged {
    private static final Logger log = LoggerFactory.getLogger(ChangeMerged.class);
    private final DynamicSet<ChangeMergedListener> listeners;
    private final EventUtil util;

    @Inject
    ChangeMerged(DynamicSet<ChangeMergedListener> listeners, EventUtil util) {
        this.listeners = listeners;
        this.util = util;
    }

    public void fire(Change change, PatchSet ps, Account merger, String newRevisionId, Timestamp when) {
        if (!this.listeners.iterator().hasNext()) {
            return;
        }
        try {
            Event event = new Event(this.util.changeInfo(change), this.util.revisionInfo(change.getProject(), ps), this.util.accountInfo(merger), newRevisionId, when);
            for (ChangeMergedListener l : this.listeners) {
                try {
                    l.onChangeMerged(event);
                }
                catch (Exception e) {
                    this.util.logEventListenerError(this, l, e);
                }
            }
        }
        catch (PatchListObjectTooLargeException e) {
            log.warn("Couldn't fire event: " + e.getMessage());
        }
        catch (GpgException | PatchListNotAvailableException | PermissionBackendException | OrmException | IOException e) {
            log.error("Couldn't fire event", e);
        }
    }

    private static class Event
    extends AbstractRevisionEvent
    implements ChangeMergedListener.Event {
        private final String newRevisionId;

        Event(ChangeInfo change, RevisionInfo revision, AccountInfo merger, String newRevisionId, Timestamp when) {
            super(change, revision, merger, when, NotifyHandling.ALL);
            this.newRevisionId = newRevisionId;
        }

        @Override
        public String getNewRevisionId() {
            return this.newRevisionId;
        }
    }
}

