/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.extensions.events;

import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.events.ChangeRevertedListener;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.extensions.events.AbstractChangeEvent;
import com.google.gerrit.server.extensions.events.EventUtil;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.sql.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ChangeReverted {
    private static final Logger log = LoggerFactory.getLogger(ChangeReverted.class);
    private final DynamicSet<ChangeRevertedListener> listeners;
    private final EventUtil util;

    @Inject
    ChangeReverted(DynamicSet<ChangeRevertedListener> listeners, EventUtil util) {
        this.listeners = listeners;
        this.util = util;
    }

    public void fire(Change change, Change revertChange, Timestamp when) {
        if (!this.listeners.iterator().hasNext()) {
            return;
        }
        try {
            Event event = new Event(this.util.changeInfo(change), this.util.changeInfo(revertChange), when);
            for (ChangeRevertedListener l : this.listeners) {
                try {
                    l.onChangeReverted(event);
                }
                catch (Exception e) {
                    this.util.logEventListenerError(this, l, e);
                }
            }
        }
        catch (OrmException e) {
            log.error("Couldn't fire event", e);
        }
    }

    private static class Event
    extends AbstractChangeEvent
    implements ChangeRevertedListener.Event {
        private final ChangeInfo revertChange;

        Event(ChangeInfo change, ChangeInfo revertChange, Timestamp when) {
            super(change, revertChange.owner, when, NotifyHandling.ALL);
            this.revertChange = revertChange;
        }

        @Override
        public ChangeInfo getRevertChange() {
            return this.revertChange;
        }
    }
}

