/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.base.Preconditions;
import com.google.gerrit.lifecycle.LifecycleModule;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.RepositoryConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.LocalDiskRepositoryManager;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.nio.file.Path;
import org.eclipse.jgit.lib.Config;

@Singleton
public class MultiBaseLocalDiskRepositoryManager
extends LocalDiskRepositoryManager {
    private final RepositoryConfig config;

    @Inject
    MultiBaseLocalDiskRepositoryManager(SitePaths site, @GerritServerConfig Config cfg, RepositoryConfig config) {
        super(site, cfg);
        this.config = config;
        for (Path alternateBasePath : config.getAllBasePaths()) {
            Preconditions.checkState(alternateBasePath.isAbsolute(), "repository.<name>.basePath must be absolute: %s", (Object)alternateBasePath);
        }
    }

    @Override
    public Path getBasePath(Project.NameKey name) {
        Path alternateBasePath = this.config.getBasePath(name);
        return alternateBasePath != null ? alternateBasePath : super.getBasePath(name);
    }

    @Override
    protected void scanProjects(LocalDiskRepositoryManager.ProjectVisitor visitor) {
        super.scanProjects(visitor);
        for (Path path : this.config.getAllBasePaths()) {
            visitor.setStartFolder(path);
            super.scanProjects(visitor);
        }
    }

    public static class Module
    extends LifecycleModule {
        @Override
        protected void configure() {
            this.bind(GitRepositoryManager.class).to(MultiBaseLocalDiskRepositoryManager.class);
            this.listener().to(LocalDiskRepositoryManager.Lifecycle.class);
        }
    }
}

