/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.AccountsCollection;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.group.AddMembers;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.GroupsUpdate;
import com.google.gerrit.server.group.MemberResource;
import com.google.gerrit.server.group.UserInitiated;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.HashSet;
import org.eclipse.jgit.errors.ConfigInvalidException;

@Singleton
public class DeleteMembers
implements RestModifyView<GroupResource, AddMembers.Input> {
    private final AccountsCollection accounts;
    private final Provider<ReviewDb> db;
    private final Provider<GroupsUpdate> groupsUpdateProvider;

    @Inject
    DeleteMembers(AccountsCollection accounts, Provider<ReviewDb> db, @UserInitiated Provider<GroupsUpdate> groupsUpdateProvider) {
        this.accounts = accounts;
        this.db = db;
        this.groupsUpdateProvider = groupsUpdateProvider;
    }

    public Response<?> apply(GroupResource resource, AddMembers.Input input) throws AuthException, MethodNotAllowedException, UnprocessableEntityException, OrmException, IOException, ConfigInvalidException, ResourceNotFoundException {
        GroupDescription.Internal internalGroup = resource.asInternalGroup().orElseThrow(MethodNotAllowedException::new);
        input = AddMembers.Input.init(input);
        GroupControl control = resource.getControl();
        if (!control.canRemoveMember()) {
            throw new AuthException("Cannot delete members from group " + internalGroup.getName());
        }
        HashSet<Account.Id> membersToRemove = new HashSet<Account.Id>();
        for (String nameOrEmail : input.members) {
            Account a = this.accounts.parse(nameOrEmail).getAccount();
            membersToRemove.add(a.getId());
        }
        AccountGroup.UUID groupUuid = internalGroup.getGroupUUID();
        try {
            this.groupsUpdateProvider.get().removeGroupMembers(this.db.get(), groupUuid, membersToRemove);
        }
        catch (NoSuchGroupException e) {
            throw new ResourceNotFoundException(String.format("Group %s not found", groupUuid));
        }
        return Response.none();
    }

    @Singleton
    static class DeleteMember
    implements RestModifyView<MemberResource, Input> {
        private final Provider<DeleteMembers> delete;

        @Inject
        DeleteMember(Provider<DeleteMembers> delete) {
            this.delete = delete;
        }

        public Response<?> apply(MemberResource resource, Input input) throws AuthException, MethodNotAllowedException, UnprocessableEntityException, OrmException, IOException, ConfigInvalidException, ResourceNotFoundException {
            AddMembers.Input in = new AddMembers.Input();
            in._oneMember = resource.getMember().getAccountId().toString();
            return this.delete.get().apply(resource, in);
        }

        static class Input {
            Input() {
            }
        }
    }
}

