/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.group.AddSubgroups;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.GroupsCollection;
import com.google.gerrit.server.group.GroupsUpdate;
import com.google.gerrit.server.group.SubgroupResource;
import com.google.gerrit.server.group.UserInitiated;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.HashSet;

@Singleton
public class DeleteSubgroups
implements RestModifyView<GroupResource, AddSubgroups.Input> {
    private final GroupsCollection groupsCollection;
    private final Provider<ReviewDb> db;
    private final Provider<GroupsUpdate> groupsUpdateProvider;

    @Inject
    DeleteSubgroups(GroupsCollection groupsCollection, Provider<ReviewDb> db, @UserInitiated Provider<GroupsUpdate> groupsUpdateProvider) {
        this.groupsCollection = groupsCollection;
        this.db = db;
        this.groupsUpdateProvider = groupsUpdateProvider;
    }

    public Response<?> apply(GroupResource resource, AddSubgroups.Input input) throws AuthException, MethodNotAllowedException, UnprocessableEntityException, OrmException, ResourceNotFoundException, IOException {
        GroupDescription.Internal internalGroup = resource.asInternalGroup().orElseThrow(MethodNotAllowedException::new);
        input = AddSubgroups.Input.init(input);
        GroupControl control = resource.getControl();
        if (!control.canRemoveGroup()) {
            throw new AuthException(String.format("Cannot delete groups from group %s", internalGroup.getName()));
        }
        HashSet<AccountGroup.UUID> subgroupsToRemove = new HashSet<AccountGroup.UUID>();
        for (String subgroupIdentifier : input.groups) {
            GroupDescription.Basic subgroup = this.groupsCollection.parse(subgroupIdentifier);
            subgroupsToRemove.add(subgroup.getGroupUUID());
        }
        AccountGroup.UUID groupUuid = internalGroup.getGroupUUID();
        try {
            this.groupsUpdateProvider.get().removeSubgroups(this.db.get(), groupUuid, subgroupsToRemove);
        }
        catch (NoSuchGroupException e) {
            throw new ResourceNotFoundException(String.format("Group %s not found", groupUuid));
        }
        return Response.none();
    }

    @Singleton
    static class DeleteSubgroup
    implements RestModifyView<SubgroupResource, Input> {
        private final Provider<DeleteSubgroups> delete;

        @Inject
        DeleteSubgroup(Provider<DeleteSubgroups> delete) {
            this.delete = delete;
        }

        public Response<?> apply(SubgroupResource resource, Input input) throws AuthException, MethodNotAllowedException, UnprocessableEntityException, OrmException, ResourceNotFoundException, IOException {
            AddSubgroups.Input in = new AddSubgroups.Input();
            in.groups = ImmutableList.of(resource.getMember().get());
            return this.delete.get().apply(resource, in);
        }

        static class Input {
            Input() {
            }
        }
    }
}

