/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.gerrit.audit.GroupMemberAuditListener;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.restapi.RestApiModule;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.group.AddMembers;
import com.google.gerrit.server.group.AddSubgroups;
import com.google.gerrit.server.group.CreateGroup;
import com.google.gerrit.server.group.DbGroupMemberAuditListener;
import com.google.gerrit.server.group.DeleteMembers;
import com.google.gerrit.server.group.DeleteSubgroups;
import com.google.gerrit.server.group.GetAuditLog;
import com.google.gerrit.server.group.GetDescription;
import com.google.gerrit.server.group.GetDetail;
import com.google.gerrit.server.group.GetGroup;
import com.google.gerrit.server.group.GetMember;
import com.google.gerrit.server.group.GetName;
import com.google.gerrit.server.group.GetOptions;
import com.google.gerrit.server.group.GetOwner;
import com.google.gerrit.server.group.GetSubgroup;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.GroupsCollection;
import com.google.gerrit.server.group.GroupsUpdate;
import com.google.gerrit.server.group.Index;
import com.google.gerrit.server.group.MemberResource;
import com.google.gerrit.server.group.MembersCollection;
import com.google.gerrit.server.group.PutDescription;
import com.google.gerrit.server.group.PutGroup;
import com.google.gerrit.server.group.PutName;
import com.google.gerrit.server.group.PutOptions;
import com.google.gerrit.server.group.PutOwner;
import com.google.gerrit.server.group.ServerInitiated;
import com.google.gerrit.server.group.SubgroupResource;
import com.google.gerrit.server.group.SubgroupsCollection;
import com.google.gerrit.server.group.UserInitiated;
import com.google.inject.Provides;

public class Module
extends RestApiModule {
    @Override
    protected void configure() {
        this.bind(GroupsCollection.class);
        DynamicMap.mapOf(this.binder(), GroupResource.GROUP_KIND);
        DynamicMap.mapOf(this.binder(), MemberResource.MEMBER_KIND);
        DynamicMap.mapOf(this.binder(), SubgroupResource.SUBGROUP_KIND);
        this.get(GroupResource.GROUP_KIND).to(GetGroup.class);
        this.put(GroupResource.GROUP_KIND).to(PutGroup.class);
        this.get(GroupResource.GROUP_KIND, "detail").to(GetDetail.class);
        this.post(GroupResource.GROUP_KIND, "index").to(Index.class);
        this.post(GroupResource.GROUP_KIND, "members").to(AddMembers.class);
        this.post(GroupResource.GROUP_KIND, "members.add").to(AddMembers.class);
        this.post(GroupResource.GROUP_KIND, "members.delete").to(DeleteMembers.class);
        this.post(GroupResource.GROUP_KIND, "groups").to(AddSubgroups.class);
        this.post(GroupResource.GROUP_KIND, "groups.add").to(AddSubgroups.class);
        this.post(GroupResource.GROUP_KIND, "groups.delete").to(DeleteSubgroups.class);
        this.get(GroupResource.GROUP_KIND, "description").to(GetDescription.class);
        this.put(GroupResource.GROUP_KIND, "description").to(PutDescription.class);
        this.delete(GroupResource.GROUP_KIND, "description").to(PutDescription.class);
        this.get(GroupResource.GROUP_KIND, "name").to(GetName.class);
        this.put(GroupResource.GROUP_KIND, "name").to(PutName.class);
        this.get(GroupResource.GROUP_KIND, "owner").to(GetOwner.class);
        this.put(GroupResource.GROUP_KIND, "owner").to(PutOwner.class);
        this.get(GroupResource.GROUP_KIND, "options").to(GetOptions.class);
        this.put(GroupResource.GROUP_KIND, "options").to(PutOptions.class);
        this.get(GroupResource.GROUP_KIND, "log.audit").to(GetAuditLog.class);
        this.child(GroupResource.GROUP_KIND, "members").to(MembersCollection.class);
        this.get(MemberResource.MEMBER_KIND).to(GetMember.class);
        this.put(MemberResource.MEMBER_KIND).to(AddMembers.UpdateMember.class);
        this.delete(MemberResource.MEMBER_KIND).to(DeleteMembers.DeleteMember.class);
        this.child(GroupResource.GROUP_KIND, "groups").to(SubgroupsCollection.class);
        this.get(SubgroupResource.SUBGROUP_KIND).to(GetSubgroup.class);
        this.put(SubgroupResource.SUBGROUP_KIND).to(AddSubgroups.UpdateSubgroup.class);
        this.delete(SubgroupResource.SUBGROUP_KIND).to(DeleteSubgroups.DeleteSubgroup.class);
        this.factory(CreateGroup.Factory.class);
        this.factory(GroupsUpdate.Factory.class);
        DynamicSet.bind(this.binder(), GroupMemberAuditListener.class).to(DbGroupMemberAuditListener.class);
    }

    @Provides
    @ServerInitiated
    GroupsUpdate provideServerInitiatedGroupsUpdate(GroupsUpdate.Factory groupsUpdateFactory) {
        return groupsUpdateFactory.create(null);
    }

    @Provides
    @UserInitiated
    GroupsUpdate provideUserInitiatedGroupsUpdate(GroupsUpdate.Factory groupsUpdateFactory, IdentifiedUser currentUser) {
        return groupsUpdateFactory.create(currentUser);
    }
}

