/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.common.GroupOptionsInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.GroupsUpdate;
import com.google.gerrit.server.group.UserInitiated;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;

@Singleton
public class PutOptions
implements RestModifyView<GroupResource, GroupOptionsInfo> {
    private final Provider<ReviewDb> db;
    private final Provider<GroupsUpdate> groupsUpdateProvider;

    @Inject
    PutOptions(Provider<ReviewDb> db, @UserInitiated Provider<GroupsUpdate> groupsUpdateProvider) {
        this.db = db;
        this.groupsUpdateProvider = groupsUpdateProvider;
    }

    public GroupOptionsInfo apply(GroupResource resource, GroupOptionsInfo input) throws MethodNotAllowedException, AuthException, BadRequestException, ResourceNotFoundException, OrmException, IOException {
        GroupDescription.Internal internalGroup = resource.asInternalGroup().orElseThrow(MethodNotAllowedException::new);
        if (!resource.getControl().isOwner()) {
            throw new AuthException("Not group owner");
        }
        if (input == null) {
            throw new BadRequestException("options are required");
        }
        if (input.visibleToAll == null) {
            input.visibleToAll = false;
        }
        if (internalGroup.isVisibleToAll() != input.visibleToAll.booleanValue()) {
            AccountGroup.UUID groupUuid = internalGroup.getGroupUUID();
            try {
                this.groupsUpdateProvider.get().updateGroup(this.db.get(), groupUuid, group -> group.setVisibleToAll(input.visibleToAll));
            }
            catch (NoSuchGroupException e) {
                throw new ResourceNotFoundException(String.format("Group %s not found", groupUuid));
            }
        }
        GroupOptionsInfo options = new GroupOptionsInfo();
        if (input.visibleToAll.booleanValue()) {
            options.visibleToAll = true;
        }
        return options;
    }
}

