/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index;

import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.index.AutoValue_RefState;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

@AutoValue
public abstract class RefState {
    public static RefState create(String ref, String sha) {
        return new AutoValue_RefState(ref, ObjectId.fromString(sha));
    }

    public static RefState create(String ref, @Nullable ObjectId id) {
        return new AutoValue_RefState(ref, MoreObjects.firstNonNull(id, ObjectId.zeroId()));
    }

    public static RefState of(Ref ref) {
        return new AutoValue_RefState(ref.getName(), ref.getObjectId());
    }

    public byte[] toByteArray(Project.NameKey project) {
        byte[] a = (project.toString() + ':' + this.ref() + ':').getBytes(StandardCharsets.UTF_8);
        byte[] b = new byte[a.length + 40];
        System.arraycopy(a, 0, b, 0, a.length);
        this.id().copyTo(b, a.length);
        return b;
    }

    public static void check(boolean condition, String str) {
        Preconditions.checkArgument(condition, "invalid RefState: %s", (Object)str);
    }

    public abstract String ref();

    public abstract ObjectId id();

    public boolean match(Repository repo) throws IOException {
        Ref ref = repo.exactRef(this.ref());
        ObjectId expected = ref != null ? ref.getObjectId() : ObjectId.zeroId();
        return this.id().equals(expected);
    }
}

