/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.receive;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.server.mail.Address;
import com.google.gerrit.server.mail.receive.MailMessage;
import org.joda.time.DateTime;

final class AutoValue_MailMessage
extends MailMessage {
    private final String id;
    private final Address from;
    private final ImmutableList<Address> to;
    private final ImmutableList<Address> cc;
    private final DateTime dateReceived;
    private final ImmutableList<String> additionalHeaders;
    private final String subject;
    private final String textContent;
    private final String htmlContent;
    private final ImmutableList<Integer> rawContent;
    private final String rawContentUTF;

    private AutoValue_MailMessage(String id, Address from, ImmutableList<Address> to, ImmutableList<Address> cc, DateTime dateReceived, ImmutableList<String> additionalHeaders, String subject, @Nullable String textContent, @Nullable String htmlContent, @Nullable ImmutableList<Integer> rawContent, @Nullable String rawContentUTF) {
        this.id = id;
        this.from = from;
        this.to = to;
        this.cc = cc;
        this.dateReceived = dateReceived;
        this.additionalHeaders = additionalHeaders;
        this.subject = subject;
        this.textContent = textContent;
        this.htmlContent = htmlContent;
        this.rawContent = rawContent;
        this.rawContentUTF = rawContentUTF;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Address from() {
        return this.from;
    }

    @Override
    public ImmutableList<Address> to() {
        return this.to;
    }

    @Override
    public ImmutableList<Address> cc() {
        return this.cc;
    }

    @Override
    public DateTime dateReceived() {
        return this.dateReceived;
    }

    @Override
    public ImmutableList<String> additionalHeaders() {
        return this.additionalHeaders;
    }

    @Override
    public String subject() {
        return this.subject;
    }

    @Override
    @Nullable
    public String textContent() {
        return this.textContent;
    }

    @Override
    @Nullable
    public String htmlContent() {
        return this.htmlContent;
    }

    @Override
    @Nullable
    public ImmutableList<Integer> rawContent() {
        return this.rawContent;
    }

    @Override
    @Nullable
    public String rawContentUTF() {
        return this.rawContentUTF;
    }

    public String toString() {
        return "MailMessage{id=" + this.id + ", from=" + this.from + ", to=" + this.to + ", cc=" + this.cc + ", dateReceived=" + this.dateReceived + ", additionalHeaders=" + this.additionalHeaders + ", subject=" + this.subject + ", textContent=" + this.textContent + ", htmlContent=" + this.htmlContent + ", rawContent=" + this.rawContent + ", rawContentUTF=" + this.rawContentUTF + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MailMessage) {
            MailMessage that = (MailMessage)o;
            return this.id.equals(that.id()) && this.from.equals(that.from()) && this.to.equals(that.to()) && this.cc.equals(that.cc()) && this.dateReceived.equals(that.dateReceived()) && this.additionalHeaders.equals(that.additionalHeaders()) && this.subject.equals(that.subject()) && (this.textContent == null ? that.textContent() == null : this.textContent.equals(that.textContent())) && (this.htmlContent == null ? that.htmlContent() == null : this.htmlContent.equals(that.htmlContent())) && (this.rawContent == null ? that.rawContent() == null : this.rawContent.equals(that.rawContent())) && (this.rawContentUTF == null ? that.rawContentUTF() == null : this.rawContentUTF.equals(that.rawContentUTF()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.id.hashCode();
        h$ *= 1000003;
        h$ ^= this.from.hashCode();
        h$ *= 1000003;
        h$ ^= this.to.hashCode();
        h$ *= 1000003;
        h$ ^= this.cc.hashCode();
        h$ *= 1000003;
        h$ ^= this.dateReceived.hashCode();
        h$ *= 1000003;
        h$ ^= this.additionalHeaders.hashCode();
        h$ *= 1000003;
        h$ ^= this.subject.hashCode();
        h$ *= 1000003;
        h$ ^= this.textContent == null ? 0 : this.textContent.hashCode();
        h$ *= 1000003;
        h$ ^= this.htmlContent == null ? 0 : this.htmlContent.hashCode();
        h$ *= 1000003;
        h$ ^= this.rawContent == null ? 0 : this.rawContent.hashCode();
        h$ *= 1000003;
        return h$ ^= this.rawContentUTF == null ? 0 : this.rawContentUTF.hashCode();
    }

    @Override
    public MailMessage.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends MailMessage.Builder {
        private String id;
        private Address from;
        private ImmutableList.Builder<Address> toBuilder$;
        private ImmutableList<Address> to;
        private ImmutableList.Builder<Address> ccBuilder$;
        private ImmutableList<Address> cc;
        private DateTime dateReceived;
        private ImmutableList.Builder<String> additionalHeadersBuilder$;
        private ImmutableList<String> additionalHeaders;
        private String subject;
        private String textContent;
        private String htmlContent;
        private ImmutableList<Integer> rawContent;
        private String rawContentUTF;

        Builder() {
        }

        private Builder(MailMessage source) {
            this.id = source.id();
            this.from = source.from();
            this.to = source.to();
            this.cc = source.cc();
            this.dateReceived = source.dateReceived();
            this.additionalHeaders = source.additionalHeaders();
            this.subject = source.subject();
            this.textContent = source.textContent();
            this.htmlContent = source.htmlContent();
            this.rawContent = source.rawContent();
            this.rawContentUTF = source.rawContentUTF();
        }

        @Override
        public MailMessage.Builder id(String id) {
            if (id == null) {
                throw new NullPointerException("Null id");
            }
            this.id = id;
            return this;
        }

        @Override
        public MailMessage.Builder from(Address from) {
            if (from == null) {
                throw new NullPointerException("Null from");
            }
            this.from = from;
            return this;
        }

        @Override
        public ImmutableList.Builder<Address> toBuilder() {
            if (this.toBuilder$ == null) {
                if (this.to == null) {
                    this.toBuilder$ = ImmutableList.builder();
                } else {
                    this.toBuilder$ = ImmutableList.builder();
                    this.toBuilder$.addAll(this.to);
                    this.to = null;
                }
            }
            return this.toBuilder$;
        }

        @Override
        public ImmutableList.Builder<Address> ccBuilder() {
            if (this.ccBuilder$ == null) {
                if (this.cc == null) {
                    this.ccBuilder$ = ImmutableList.builder();
                } else {
                    this.ccBuilder$ = ImmutableList.builder();
                    this.ccBuilder$.addAll(this.cc);
                    this.cc = null;
                }
            }
            return this.ccBuilder$;
        }

        @Override
        public MailMessage.Builder dateReceived(DateTime dateReceived) {
            if (dateReceived == null) {
                throw new NullPointerException("Null dateReceived");
            }
            this.dateReceived = dateReceived;
            return this;
        }

        @Override
        public ImmutableList.Builder<String> additionalHeadersBuilder() {
            if (this.additionalHeadersBuilder$ == null) {
                if (this.additionalHeaders == null) {
                    this.additionalHeadersBuilder$ = ImmutableList.builder();
                } else {
                    this.additionalHeadersBuilder$ = ImmutableList.builder();
                    this.additionalHeadersBuilder$.addAll(this.additionalHeaders);
                    this.additionalHeaders = null;
                }
            }
            return this.additionalHeadersBuilder$;
        }

        @Override
        public MailMessage.Builder subject(String subject) {
            if (subject == null) {
                throw new NullPointerException("Null subject");
            }
            this.subject = subject;
            return this;
        }

        @Override
        public MailMessage.Builder textContent(String textContent) {
            this.textContent = textContent;
            return this;
        }

        @Override
        public MailMessage.Builder htmlContent(String htmlContent) {
            this.htmlContent = htmlContent;
            return this;
        }

        @Override
        public MailMessage.Builder rawContent(ImmutableList<Integer> rawContent) {
            this.rawContent = rawContent;
            return this;
        }

        @Override
        public MailMessage.Builder rawContentUTF(String rawContentUTF) {
            this.rawContentUTF = rawContentUTF;
            return this;
        }

        @Override
        public MailMessage build() {
            if (this.toBuilder$ != null) {
                this.to = this.toBuilder$.build();
            } else if (this.to == null) {
                this.to = ImmutableList.of();
            }
            if (this.ccBuilder$ != null) {
                this.cc = this.ccBuilder$.build();
            } else if (this.cc == null) {
                this.cc = ImmutableList.of();
            }
            if (this.additionalHeadersBuilder$ != null) {
                this.additionalHeaders = this.additionalHeadersBuilder$.build();
            } else if (this.additionalHeaders == null) {
                this.additionalHeaders = ImmutableList.of();
            }
            String missing = "";
            if (this.id == null) {
                missing = missing + " id";
            }
            if (this.from == null) {
                missing = missing + " from";
            }
            if (this.dateReceived == null) {
                missing = missing + " dateReceived";
            }
            if (this.subject == null) {
                missing = missing + " subject";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_MailMessage(this.id, this.from, this.to, this.cc, this.dateReceived, this.additionalHeaders, this.subject, this.textContent, this.htmlContent, this.rawContent, this.rawContentUTF);
        }
    }
}

