/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.receive;

import com.google.common.primitives.Ints;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.mail.EmailSettings;
import com.google.gerrit.server.mail.Encryption;
import com.google.gerrit.server.mail.receive.MailMessage;
import com.google.gerrit.server.mail.receive.MailParsingException;
import com.google.gerrit.server.mail.receive.MailProcessor;
import com.google.gerrit.server.mail.receive.MailReceiver;
import com.google.gerrit.server.mail.receive.MailTransferException;
import com.google.gerrit.server.mail.receive.RawMailParser;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.net.pop3.POP3Client;
import org.apache.commons.net.pop3.POP3MessageInfo;
import org.apache.commons.net.pop3.POP3SClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Pop3MailReceiver
extends MailReceiver {
    private static final Logger log = LoggerFactory.getLogger(Pop3MailReceiver.class);

    @Inject
    Pop3MailReceiver(EmailSettings mailSettings, MailProcessor mailProcessor, WorkQueue workQueue) {
        super(mailSettings, mailProcessor, workQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void handleEmails(boolean async) throws MailTransferException, IOException {
        POP3Client pop3 = this.mailSettings.encryption != Encryption.NONE ? new POP3SClient(this.mailSettings.encryption.name(), true) : new POP3Client();
        if (this.mailSettings.port > 0) {
            pop3.setDefaultPort(this.mailSettings.port);
        }
        pop3.connect(this.mailSettings.host);
        try {
            if (!pop3.login(this.mailSettings.username, this.mailSettings.password)) {
                throw new MailTransferException("Could not login to POP3 email server. Check username and password");
            }
            try {
                POP3MessageInfo[] messages = pop3.listMessages();
                if (messages == null) {
                    throw new MailTransferException("Could not retrieve message list via POP3");
                }
                log.info("Received " + messages.length + " messages via POP3");
                ArrayList<MailMessage> mailMessages = new ArrayList<MailMessage>();
                for (POP3MessageInfo msginfo : messages) {
                    if (msginfo == null) continue;
                    try (BufferedReader reader = (BufferedReader)pop3.retrieveMessage(msginfo.number);){
                        if (reader == null) {
                            throw new MailTransferException("Could not retrieve POP3 message header for message " + msginfo.identifier);
                        }
                        int[] message = this.fetchMessage(reader);
                        MailMessage mailMessage = RawMailParser.parse(message);
                        if (this.pendingDeletion.contains(mailMessage.id())) {
                            if (pop3.deleteMessage(msginfo.number)) {
                                this.pendingDeletion.remove(mailMessage.id());
                                continue;
                            }
                            log.error("Could not delete message " + msginfo.number);
                            continue;
                        }
                        mailMessages.add(mailMessage);
                    }
                    catch (MailParsingException e) {
                        log.error("Could not parse message " + msginfo.number);
                    }
                }
                this.dispatchMailProcessor(mailMessages, async);
            }
            finally {
                pop3.logout();
            }
        }
        finally {
            pop3.disconnect();
        }
    }

    public final int[] fetchMessage(BufferedReader reader) throws IOException {
        int ch;
        ArrayList<Integer> character = new ArrayList<Integer>();
        while ((ch = reader.read()) != -1) {
            character.add(ch);
        }
        return Ints.toArray(character);
    }
}

