/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gerrit.extensions.config.FactoryModule;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.notedb.ChangeBundle;
import com.google.gerrit.server.notedb.ChangeDraftUpdate;
import com.google.gerrit.server.notedb.ChangeNotesCache;
import com.google.gerrit.server.notedb.ChangeNotesState;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.DeleteCommentRewriter;
import com.google.gerrit.server.notedb.DraftCommentNotes;
import com.google.gerrit.server.notedb.NoteDbUpdateManager;
import com.google.gerrit.server.notedb.RobotCommentNotes;
import com.google.gerrit.server.notedb.RobotCommentUpdate;
import com.google.gerrit.server.notedb.TestChangeRebuilderWrapper;
import com.google.gerrit.server.notedb.rebuild.ChangeRebuilder;
import com.google.gerrit.server.notedb.rebuild.ChangeRebuilderImpl;
import com.google.gerrit.server.notedb.rebuild.NotesMigrationStateListener;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import org.eclipse.jgit.lib.Config;

public class NoteDbModule
extends FactoryModule {
    private final Config cfg;
    private final boolean useTestBindings;

    static NoteDbModule forTest(Config cfg) {
        return new NoteDbModule(cfg, true);
    }

    public NoteDbModule(Config cfg) {
        this(cfg, false);
    }

    private NoteDbModule(Config cfg, boolean useTestBindings) {
        this.cfg = cfg;
        this.useTestBindings = useTestBindings;
    }

    @Override
    public void configure() {
        this.factory(ChangeDraftUpdate.Factory.class);
        this.factory(ChangeUpdate.Factory.class);
        this.factory(DeleteCommentRewriter.Factory.class);
        this.factory(DraftCommentNotes.Factory.class);
        this.factory(NoteDbUpdateManager.Factory.class);
        this.factory(RobotCommentNotes.Factory.class);
        this.factory(RobotCommentUpdate.Factory.class);
        DynamicSet.setOf(this.binder(), NotesMigrationStateListener.class);
        if (!this.useTestBindings) {
            this.install(ChangeNotesCache.module());
            if (this.cfg.getBoolean("noteDb", null, "testRebuilderWrapper", false)) {
                this.bind(ChangeRebuilder.class).to(TestChangeRebuilderWrapper.class);
            } else {
                this.bind(ChangeRebuilder.class).to(ChangeRebuilderImpl.class);
            }
        } else {
            this.bind(ChangeRebuilder.class).toInstance(new ChangeRebuilder(null){

                @Override
                public NoteDbUpdateManager.Result rebuild(ReviewDb db, Change.Id changeId) {
                    return null;
                }

                @Override
                public NoteDbUpdateManager.Result rebuildEvenIfReadOnly(ReviewDb db, Change.Id changeId) {
                    return null;
                }

                @Override
                public NoteDbUpdateManager.Result rebuild(NoteDbUpdateManager manager, ChangeBundle bundle) {
                    return null;
                }

                @Override
                public NoteDbUpdateManager stage(ReviewDb db, Change.Id changeId) {
                    return null;
                }

                @Override
                public NoteDbUpdateManager.Result execute(ReviewDb db, Change.Id changeId, NoteDbUpdateManager manager) {
                    return null;
                }

                @Override
                public void buildUpdates(NoteDbUpdateManager manager, ChangeBundle bundle) {
                }

                @Override
                public void rebuildReviewDb(ReviewDb db, Project.NameKey project, Change.Id changeId) {
                }
            });
            this.bind(new TypeLiteral<Cache<ChangeNotesCache.Key, ChangeNotesState>>(){}).annotatedWith(Names.named("change_notes")).toInstance(CacheBuilder.newBuilder().build());
        }
    }
}

