/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.gerrit.extensions.client.ReviewerState;
import java.util.Arrays;
import org.eclipse.jgit.revwalk.FooterKey;

public enum ReviewerStateInternal {
    REVIEWER(new FooterKey("Reviewer"), ReviewerState.REVIEWER),
    CC(new FooterKey("CC"), ReviewerState.CC),
    REMOVED(new FooterKey("Removed"), ReviewerState.REMOVED);

    private final FooterKey footerKey;
    private final ReviewerState state;

    public static ReviewerStateInternal fromReviewerState(ReviewerState state) {
        return ReviewerStateInternal.values()[state.ordinal()];
    }

    private ReviewerStateInternal(FooterKey footerKey, ReviewerState state) {
        this.footerKey = footerKey;
        this.state = state;
    }

    FooterKey getFooterKey() {
        return this.footerKey;
    }

    FooterKey getByEmailFooterKey() {
        return new FooterKey(this.footerKey.getName() + "-email");
    }

    public ReviewerState asReviewerState() {
        return this.state;
    }

    static {
        boolean ok = true;
        if (ReviewerStateInternal.values().length != ReviewerState.values().length) {
            ok = false;
        }
        for (int i = 0; i < ReviewerStateInternal.values().length; ++i) {
            ok &= ReviewerState.values()[i].equals((Object)ReviewerStateInternal.values()[i].state);
        }
        if (!ok) {
            throw new IllegalStateException("Mismatched reviewer state mapping: " + Arrays.asList(ReviewerStateInternal.values()) + " != " + Arrays.asList(ReviewerState.values()));
        }
    }
}

