/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb.rebuild;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.primitives.Ints;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.reviewdb.server.ReviewDbUtil;
import com.google.gerrit.server.CommentsUtil;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.config.AnonymousCowardName;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.GerritServerId;
import com.google.gerrit.server.notedb.ChangeBundle;
import com.google.gerrit.server.notedb.ChangeBundleReader;
import com.google.gerrit.server.notedb.ChangeDraftUpdate;
import com.google.gerrit.server.notedb.ChangeNoteUtil;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.NoteDbChangeState;
import com.google.gerrit.server.notedb.NoteDbUpdateManager;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.notedb.ReviewerStateInternal;
import com.google.gerrit.server.notedb.rebuild.AbortUpdateException;
import com.google.gerrit.server.notedb.rebuild.ApprovalEvent;
import com.google.gerrit.server.notedb.rebuild.ChangeMessageEvent;
import com.google.gerrit.server.notedb.rebuild.ChangeRebuilder;
import com.google.gerrit.server.notedb.rebuild.CommentEvent;
import com.google.gerrit.server.notedb.rebuild.ConflictingUpdateException;
import com.google.gerrit.server.notedb.rebuild.ConflictingUpdateRuntimeException;
import com.google.gerrit.server.notedb.rebuild.CreateChangeEvent;
import com.google.gerrit.server.notedb.rebuild.DraftCommentEvent;
import com.google.gerrit.server.notedb.rebuild.Event;
import com.google.gerrit.server.notedb.rebuild.EventList;
import com.google.gerrit.server.notedb.rebuild.EventSorter;
import com.google.gerrit.server.notedb.rebuild.FinalUpdatesEvent;
import com.google.gerrit.server.notedb.rebuild.HashtagsEvent;
import com.google.gerrit.server.notedb.rebuild.PatchSetEvent;
import com.google.gerrit.server.notedb.rebuild.ReviewerEvent;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.update.ChainedReceiveCommands;
import com.google.gwtorm.client.Key;
import com.google.gwtorm.server.Access;
import com.google.gwtorm.server.AtomicUpdate;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;

public class ChangeRebuilderImpl
extends ChangeRebuilder {
    public static final long MAX_WINDOW_MS = TimeUnit.SECONDS.toMillis(3L);
    static final long MAX_DELTA_MS = TimeUnit.SECONDS.toMillis(1L);
    private final AccountCache accountCache;
    private final ChangeBundleReader bundleReader;
    private final ChangeDraftUpdate.Factory draftUpdateFactory;
    private final ChangeNoteUtil changeNoteUtil;
    private final ChangeNotes.Factory notesFactory;
    private final ChangeUpdate.Factory updateFactory;
    private final CommentsUtil commentsUtil;
    private final NoteDbUpdateManager.Factory updateManagerFactory;
    private final NotesMigration migration;
    private final PatchListCache patchListCache;
    private final PersonIdent serverIdent;
    private final ProjectCache projectCache;
    private final String anonymousCowardName;
    private final String serverId;
    private final long skewMs;

    @Inject
    ChangeRebuilderImpl(@GerritServerConfig Config cfg, SchemaFactory<ReviewDb> schemaFactory, AccountCache accountCache, ChangeBundleReader bundleReader, ChangeDraftUpdate.Factory draftUpdateFactory, ChangeNoteUtil changeNoteUtil, ChangeNotes.Factory notesFactory, ChangeUpdate.Factory updateFactory, CommentsUtil commentsUtil, NoteDbUpdateManager.Factory updateManagerFactory, NotesMigration migration, PatchListCache patchListCache, @GerritPersonIdent PersonIdent serverIdent, @Nullable ProjectCache projectCache, @AnonymousCowardName String anonymousCowardName, @GerritServerId String serverId) {
        super(schemaFactory);
        this.accountCache = accountCache;
        this.bundleReader = bundleReader;
        this.draftUpdateFactory = draftUpdateFactory;
        this.changeNoteUtil = changeNoteUtil;
        this.notesFactory = notesFactory;
        this.updateFactory = updateFactory;
        this.commentsUtil = commentsUtil;
        this.updateManagerFactory = updateManagerFactory;
        this.migration = migration;
        this.patchListCache = patchListCache;
        this.serverIdent = serverIdent;
        this.projectCache = projectCache;
        this.anonymousCowardName = anonymousCowardName;
        this.serverId = serverId;
        this.skewMs = NoteDbChangeState.getReadOnlySkew(cfg);
    }

    @Override
    public NoteDbUpdateManager.Result rebuild(ReviewDb db, Change.Id changeId) throws IOException, OrmException {
        return this.rebuild(db, changeId, true);
    }

    @Override
    public NoteDbUpdateManager.Result rebuildEvenIfReadOnly(ReviewDb db, Change.Id changeId) throws IOException, OrmException {
        return this.rebuild(db, changeId, false);
    }

    private NoteDbUpdateManager.Result rebuild(ReviewDb db, Change.Id changeId, boolean checkReadOnly) throws IOException, OrmException {
        Change change = (db = ReviewDbUtil.unwrapDb(db)).changes().get(changeId);
        if (change == null) {
            throw new NoSuchChangeException(changeId);
        }
        try (NoteDbUpdateManager manager = this.updateManagerFactory.create(change.getProject());){
            this.buildUpdates(manager, this.bundleReader.fromReviewDb(db, changeId));
            NoteDbUpdateManager.Result result = this.execute(db, changeId, manager, checkReadOnly, true);
            return result;
        }
    }

    @Override
    public NoteDbUpdateManager.Result rebuild(NoteDbUpdateManager manager, ChangeBundle bundle) throws NoSuchChangeException, IOException, OrmException {
        Change change = new Change(bundle.getChange());
        this.buildUpdates(manager, bundle);
        return manager.stageAndApplyDelta(change);
    }

    @Override
    public NoteDbUpdateManager stage(ReviewDb db, Change.Id changeId) throws IOException, OrmException {
        Change change = ChangeRebuilderImpl.checkNoteDbState(ChangeNotes.readOneReviewDbChange(db = ReviewDbUtil.unwrapDb(db), changeId));
        if (change == null) {
            throw new NoSuchChangeException(changeId);
        }
        NoteDbUpdateManager manager = this.updateManagerFactory.create(change.getProject());
        this.buildUpdates(manager, this.bundleReader.fromReviewDb(db, changeId));
        manager.stage();
        return manager;
    }

    @Override
    public NoteDbUpdateManager.Result execute(ReviewDb db, Change.Id changeId, NoteDbUpdateManager manager) throws OrmException, IOException {
        return this.execute(db, changeId, manager, true, true);
    }

    public NoteDbUpdateManager.Result execute(ReviewDb db, Change.Id changeId, NoteDbUpdateManager manager, final boolean checkReadOnly, boolean executeManager) throws OrmException, IOException {
        NoteDbUpdateManager.Result r;
        block7: {
            Change change = ChangeRebuilderImpl.checkNoteDbState(ChangeNotes.readOneReviewDbChange(db = ReviewDbUtil.unwrapDb(db), changeId));
            if (change == null) {
                throw new NoSuchChangeException(changeId);
            }
            final String oldNoteDbStateStr = change.getNoteDbState();
            r = manager.stageAndApplyDelta(change);
            final String newNoteDbStateStr = change.getNoteDbState();
            if (newNoteDbStateStr == null) {
                throw new OrmException("Rebuilding change %s produced no writes to NoteDb: " + this.bundleReader.fromReviewDb(db, changeId));
            }
            NoteDbChangeState newNoteDbState = Preconditions.checkNotNull(NoteDbChangeState.parse(changeId, newNoteDbStateStr));
            try {
                db.changes().atomicUpdate(changeId, new AtomicUpdate<Change>(){

                    @Override
                    public Change update(Change change) {
                        String currNoteDbStateStr;
                        if (checkReadOnly) {
                            NoteDbChangeState.checkNotReadOnly(change, ChangeRebuilderImpl.this.skewMs);
                        }
                        if (Objects.equals(currNoteDbStateStr = change.getNoteDbState(), newNoteDbStateStr)) {
                            throw new AbortUpdateException();
                        }
                        if (!Objects.equals(oldNoteDbStateStr, currNoteDbStateStr)) {
                            throw new ConflictingUpdateRuntimeException(change, oldNoteDbStateStr);
                        }
                        change.setNoteDbState(newNoteDbStateStr);
                        return change;
                    }
                });
            }
            catch (ConflictingUpdateRuntimeException e) {
                throw new ConflictingUpdateException(e);
            }
            catch (AbortUpdateException e) {
                if (!newNoteDbState.isUpToDate(manager.getChangeRepo().cmds.getRepoRefCache(), manager.getAllUsersRepo().cmds.getRepoRefCache())) break block7;
                return r;
            }
        }
        if (this.migration.failChangeWrites()) {
            throw new OrmException("NoteDb changes are read-only");
        }
        if (executeManager) {
            manager.execute();
        }
        return r;
    }

    static Change checkNoteDbState(Change c) throws OrmException {
        NoteDbChangeState s = NoteDbChangeState.parse(c);
        if (s != null && s.getPrimaryStorage() != NoteDbChangeState.PrimaryStorage.REVIEW_DB) {
            throw new OrmException(String.format("cannot rebuild change " + c.getId() + " with state " + s, new Object[0]));
        }
        return c;
    }

    @Override
    public void buildUpdates(NoteDbUpdateManager manager, ChangeBundle bundle) throws IOException, OrmException {
        manager.setCheckExpectedState(false).setRefLogMessage("Rebuilding change");
        Change change = new Change(bundle.getChange());
        if (bundle.getPatchSets().isEmpty()) {
            throw new ChangeRebuilder.NoPatchSetsException(change.getId());
        }
        if (change.getLastUpdatedOn().compareTo(change.getCreatedOn()) < 0) {
            change.setCreatedOn(change.getLastUpdatedOn());
        }
        ArrayList<Event> events = new ArrayList<Event>();
        Multimap draftCommentEvents = MultimapBuilder.hashKeys().arrayListValues().build();
        events.addAll(this.getHashtagsEvents(change, manager));
        this.deleteChangeMetaRef(change, manager.getChangeRepo().cmds);
        this.deleteDraftRefs(change, manager.getAllUsersRepo());
        Integer minPsNum = ChangeRebuilderImpl.getMinPatchSetNum(bundle);
        TreeMap<PatchSet.Id, PatchSetEvent> patchSetEvents = new TreeMap<PatchSet.Id, PatchSetEvent>(ReviewDbUtil.intKeyOrdering());
        for (PatchSet ps : bundle.getPatchSets()) {
            Event e;
            PatchSetEvent patchSetEvent = new PatchSetEvent(change, ps, manager.getChangeRepo().rw);
            patchSetEvents.put(ps.getId(), patchSetEvent);
            events.add(patchSetEvent);
            for (Comment c : ChangeRebuilderImpl.getComments(bundle, this.serverId, PatchLineComment.Status.PUBLISHED, ps)) {
                e = new CommentEvent(c, change, ps, this.patchListCache);
                events.add(e.addDep(patchSetEvent));
            }
            for (Comment c : ChangeRebuilderImpl.getComments(bundle, this.serverId, PatchLineComment.Status.DRAFT, ps)) {
                e = new DraftCommentEvent(c, change, ps, this.patchListCache);
                draftCommentEvents.put(c.author.getId(), e);
            }
        }
        ChangeRebuilderImpl.ensurePatchSetOrder(patchSetEvents);
        for (PatchSetApproval psa : bundle.getPatchSetApprovals()) {
            PatchSetEvent patchSetEvent = patchSetEvents.get(psa.getPatchSetId());
            if (patchSetEvent == null) continue;
            events.add(new ApprovalEvent(psa, change.getCreatedOn()).addDep(patchSetEvent));
        }
        for (Object r : bundle.getReviewers().asTable().cellSet()) {
            events.add(new ReviewerEvent((Table.Cell<ReviewerStateInternal, Account.Id, Timestamp>)r, change.getCreatedOn()));
        }
        Change noteDbChange = new Change(null, null, null, null, null);
        for (ChangeMessage changeMessage : bundle.getChangeMessages()) {
            ChangeMessageEvent msgEvent = new ChangeMessageEvent(change, noteDbChange, changeMessage, change.getCreatedOn());
            if (changeMessage.getPatchSetId() != null) {
                PatchSetEvent pse2 = patchSetEvents.get(changeMessage.getPatchSetId());
                if (pse2 == null) continue;
                msgEvent.addDep(pse2);
            }
            events.add(msgEvent);
        }
        this.sortAndFillEvents(change, noteDbChange, bundle.getPatchSets(), events, minPsNum);
        EventList<Event> el = new EventList<Event>();
        for (Event e : events) {
            if (!el.canAdd(e)) {
                this.flushEventsToUpdate(manager, el, change);
                Preconditions.checkState(el.canAdd(e));
            }
            el.add(e);
        }
        this.flushEventsToUpdate(manager, el, change);
        EventList<DraftCommentEvent> eventList = new EventList<DraftCommentEvent>();
        for (Account.Id author : draftCommentEvents.keys()) {
            for (DraftCommentEvent e : Ordering.natural().sortedCopy(draftCommentEvents.get(author))) {
                if (!eventList.canAdd(e)) {
                    this.flushEventsToDraftUpdate(manager, eventList, change);
                    Preconditions.checkState(eventList.canAdd(e));
                }
                eventList.add(e);
            }
            this.flushEventsToDraftUpdate(manager, eventList, change);
        }
    }

    private static Integer getMinPatchSetNum(ChangeBundle bundle) {
        Integer minPsNum = null;
        for (PatchSet ps : bundle.getPatchSets()) {
            int n = ps.getId().get();
            if (minPsNum != null && n >= minPsNum) continue;
            minPsNum = n;
        }
        return minPsNum;
    }

    private static void ensurePatchSetOrder(TreeMap<PatchSet.Id, PatchSetEvent> events) {
        if (events.isEmpty()) {
            return;
        }
        Iterator<PatchSetEvent> it = events.values().iterator();
        PatchSetEvent curr = it.next();
        while (it.hasNext()) {
            PatchSetEvent next = it.next();
            next.addDep(curr);
            curr = next;
        }
    }

    private static List<Comment> getComments(ChangeBundle bundle, String serverId, PatchLineComment.Status status, PatchSet ps) {
        return bundle.getPatchLineComments().stream().filter(c -> c.getPatchSetId().equals(ps.getId()) && c.getStatus() == status).map(plc -> plc.asComment(serverId)).sorted(CommentsUtil.COMMENT_ORDER).collect(Collectors.toList());
    }

    private void sortAndFillEvents(Change change, Change noteDbChange, ImmutableCollection<PatchSet> patchSets, List<Event> events, Integer minPsNum) {
        FinalUpdatesEvent finalUpdates = new FinalUpdatesEvent(change, noteDbChange, patchSets);
        events.add(finalUpdates);
        this.setPostSubmitDeps(events);
        new EventSorter(events).sort();
        Event first = events.get(0);
        if (first instanceof PatchSetEvent && change.getOwner().equals(first.user)) {
            first.when = change.getCreatedOn();
            ((PatchSetEvent)first).createChange = true;
        } else {
            events.add(0, new CreateChangeEvent(change, minPsNum));
        }
        int ps = MoreObjects.firstNonNull(minPsNum, 1);
        for (int i = 0; i < events.size(); ++i) {
            Event e = events.get(i);
            if (e.psId == null) {
                e.psId = new PatchSet.Id(change.getId(), ps);
            } else {
                ps = Math.max(ps, e.psId.get());
            }
            if (i <= 0) continue;
            Event p = events.get(i - 1);
            if (!e.when.before(p.when)) continue;
            e.when = p.when;
        }
    }

    private void setPostSubmitDeps(List<Event> events) {
        Optional<Event> submitEvent = Lists.reverse(events).stream().filter(Event::isSubmit).findFirst();
        if (submitEvent.isPresent()) {
            events.stream().filter(Event::isPostSubmitApproval).forEach(e -> e.addDep((Event)submitEvent.get()));
        }
    }

    private void flushEventsToUpdate(NoteDbUpdateManager manager, EventList<Event> events, Change change) throws OrmException, IOException {
        if (events.isEmpty()) {
            return;
        }
        Comparator<Object> labelNameComparator = this.projectCache != null ? this.projectCache.get(change.getProject()).getLabelTypes().nameComparator() : Ordering.natural();
        ChangeUpdate update = this.updateFactory.create(change, events.getAccountId(), events.getRealAccountId(), this.newAuthorIdent(events), events.getWhen(), labelNameComparator);
        update.setAllowWriteToNewRef(true);
        update.setPatchSetId(events.getPatchSetId());
        update.setTag(events.getTag());
        for (Event e : events) {
            e.apply(update);
        }
        manager.add(update);
        events.clear();
    }

    private void flushEventsToDraftUpdate(NoteDbUpdateManager manager, EventList<DraftCommentEvent> events, Change change) {
        if (events.isEmpty()) {
            return;
        }
        ChangeDraftUpdate update = this.draftUpdateFactory.create(change, events.getAccountId(), events.getRealAccountId(), this.newAuthorIdent(events), (Date)events.getWhen());
        update.setPatchSetId(events.getPatchSetId());
        for (DraftCommentEvent e : events) {
            e.applyDraft(update);
        }
        manager.add(update);
        events.clear();
    }

    private PersonIdent newAuthorIdent(EventList<?> events) {
        Account.Id id = events.getAccountId();
        if (id == null) {
            return new PersonIdent(this.serverIdent, events.getWhen());
        }
        return this.changeNoteUtil.newIdent(this.accountCache.get(id).getAccount(), events.getWhen(), this.serverIdent, this.anonymousCowardName);
    }

    private List<HashtagsEvent> getHashtagsEvents(Change change, NoteDbUpdateManager manager) throws IOException {
        String refName = RefNames.changeMetaRef(change.getId());
        Optional<ObjectId> old = manager.getChangeRepo().getObjectId(refName);
        if (!old.isPresent()) {
            return Collections.emptyList();
        }
        RevWalk rw = manager.getChangeRepo().rw;
        ArrayList<HashtagsEvent> events = new ArrayList<HashtagsEvent>();
        rw.reset();
        rw.markStart(rw.parseCommit(old.get()));
        for (RevCommit commit : rw) {
            Account.Id authorId;
            try {
                authorId = this.changeNoteUtil.parseIdent(commit.getAuthorIdent(), change.getId());
            }
            catch (ConfigInvalidException e) {
                continue;
            }
            PatchSet.Id psId = this.parsePatchSetId(change, commit);
            Set<String> hashtags = this.parseHashtags(commit);
            if (authorId == null || psId == null || hashtags == null) continue;
            Timestamp commitTime = new Timestamp(commit.getCommitterIdent().getWhen().getTime());
            events.add(new HashtagsEvent(psId, authorId, commitTime, hashtags, change.getCreatedOn()));
        }
        return events;
    }

    private Set<String> parseHashtags(RevCommit commit) {
        List<String> hashtagsLines = commit.getFooterLines(ChangeNoteUtil.FOOTER_HASHTAGS);
        if (hashtagsLines.isEmpty() || hashtagsLines.size() > 1) {
            return null;
        }
        if (hashtagsLines.get(0).isEmpty()) {
            return ImmutableSet.of();
        }
        return Sets.newHashSet(Splitter.on(',').split(hashtagsLines.get(0)));
    }

    private PatchSet.Id parsePatchSetId(Change change, RevCommit commit) {
        List<String> psIdLines = commit.getFooterLines(ChangeNoteUtil.FOOTER_PATCH_SET);
        if (psIdLines.size() != 1) {
            return null;
        }
        Integer psId = Ints.tryParse(psIdLines.get(0));
        if (psId == null) {
            return null;
        }
        return new PatchSet.Id(change.getId(), psId);
    }

    private void deleteChangeMetaRef(Change change, ChainedReceiveCommands cmds) throws IOException {
        String refName = RefNames.changeMetaRef(change.getId());
        Optional<ObjectId> old = cmds.get(refName);
        if (old.isPresent()) {
            cmds.add(new ReceiveCommand(old.get(), ObjectId.zeroId(), refName));
        }
    }

    private void deleteDraftRefs(Change change, NoteDbUpdateManager.OpenRepo allUsersRepo) throws IOException {
        for (Ref r : allUsersRepo.repo.getRefDatabase().getRefs(RefNames.refsDraftCommentsPrefix(change.getId())).values()) {
            allUsersRepo.cmds.add(new ReceiveCommand(r.getObjectId(), ObjectId.zeroId(), r.getName()));
        }
    }

    static void createChange(ChangeUpdate update, Change change) {
        update.setSubjectForCommit("Create change");
        update.setChangeId(change.getKey().get());
        update.setBranch(change.getDest().get());
        update.setSubject(change.getOriginalSubject());
        if (change.getRevertOf() != null) {
            update.setRevertOf(change.getRevertOf().get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebuildReviewDb(ReviewDb db, Project.NameKey project, Change.Id changeId) throws OrmException {
        ChangeNotes notes = this.notesFactory.create(db, project, changeId);
        ChangeBundle bundle = ChangeBundle.fromNotes(this.commentsUtil, notes);
        db = ReviewDbUtil.unwrapDb(db);
        db.changes().beginTransaction(changeId);
        try {
            Change c = db.changes().get(changeId);
            if (c != null) {
                NoteDbChangeState.PrimaryStorage ps = NoteDbChangeState.PrimaryStorage.of(c);
                switch (ps) {
                    case REVIEW_DB: {
                        return;
                    }
                    case NOTE_DB: {
                        break;
                    }
                    default: {
                        throw new OrmException("primary storage of " + changeId + " is " + (Object)((Object)ps));
                    }
                }
            } else {
                c = notes.getChange();
            }
            db.changes().upsert(Collections.singleton(c));
            ChangeRebuilderImpl.putExactlyEntities(db.changeMessages(), db.changeMessages().byChange(c.getId()), bundle.getChangeMessages());
            ChangeRebuilderImpl.putExactlyEntities(db.patchSets(), db.patchSets().byChange(c.getId()), bundle.getPatchSets());
            ChangeRebuilderImpl.putExactlyEntities(db.patchSetApprovals(), db.patchSetApprovals().byChange(c.getId()), bundle.getPatchSetApprovals());
            ChangeRebuilderImpl.putExactlyEntities(db.patchComments(), db.patchComments().byChange(c.getId()), bundle.getPatchLineComments());
            db.commit();
        }
        finally {
            db.rollback();
        }
    }

    private static <T, K extends Key<?>> void putExactlyEntities(Access<T, K> access, Iterable<T> existing, Collection<T> ents) throws OrmException {
        Set toKeep = access.toMap(ents).keySet();
        access.delete(FluentIterable.from(existing).filter(e -> !toKeep.contains(access.primaryKey(e))));
        access.upsert(ents);
    }
}

