/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.registration.RegistrationHandle;
import com.google.gerrit.extensions.registration.ReloadableRegistrationHandle;
import com.google.gerrit.lifecycle.LifecycleManager;
import com.google.gerrit.server.PluginUser;
import com.google.gerrit.server.plugins.AutoRegisterModules;
import com.google.gerrit.server.plugins.InvalidPluginException;
import com.google.gerrit.server.plugins.Plugin;
import com.google.gerrit.server.plugins.PluginContentScanner;
import com.google.gerrit.server.plugins.PluginGuiceEnvironment;
import com.google.gerrit.server.plugins.ServerPluginInfoModule;
import com.google.gerrit.server.util.RequestContext;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ServerPlugin.class);
    private final Manifest manifest;
    private final PluginContentScanner scanner;
    private final Path dataDir;
    private final String pluginCanonicalWebUrl;
    private final ClassLoader classLoader;
    private final String metricsPrefix;
    protected Class<? extends Module> sysModule;
    protected Class<? extends Module> sshModule;
    protected Class<? extends Module> httpModule;
    private Injector sysInjector;
    private Injector sshInjector;
    private Injector httpInjector;
    private LifecycleManager serverManager;
    private List<ReloadableRegistrationHandle<?>> reloadableHandles;

    public ServerPlugin(String name, String pluginCanonicalWebUrl, PluginUser pluginUser, Path srcJar, FileSnapshot snapshot, PluginContentScanner scanner, Path dataDir, ClassLoader classLoader, String metricsPrefix) throws InvalidPluginException {
        super(name, srcJar, pluginUser, snapshot, scanner == null ? Plugin.ApiType.PLUGIN : Plugin.getApiType(ServerPlugin.getPluginManifest(scanner)));
        this.pluginCanonicalWebUrl = pluginCanonicalWebUrl;
        this.scanner = scanner;
        this.dataDir = dataDir;
        this.classLoader = classLoader;
        this.manifest = scanner == null ? null : ServerPlugin.getPluginManifest(scanner);
        this.metricsPrefix = metricsPrefix;
        if (this.manifest != null) {
            this.loadGuiceModules(this.manifest, classLoader);
        }
    }

    public ServerPlugin(String name, String pluginCanonicalWebUrl, PluginUser pluginUser, Path srcJar, FileSnapshot snapshot, PluginContentScanner scanner, Path dataDir, ClassLoader classLoader) throws InvalidPluginException {
        this(name, pluginCanonicalWebUrl, pluginUser, srcJar, snapshot, scanner, dataDir, classLoader, null);
    }

    private void loadGuiceModules(Manifest manifest, ClassLoader classLoader) throws InvalidPluginException {
        Attributes main = manifest.getMainAttributes();
        String sysName = main.getValue("Gerrit-Module");
        String sshName = main.getValue("Gerrit-SshModule");
        String httpName = main.getValue("Gerrit-HttpModule");
        if (!Strings.isNullOrEmpty(sshName) && this.getApiType() != Plugin.ApiType.PLUGIN) {
            throw new InvalidPluginException(String.format("Using Gerrit-SshModule requires Gerrit-ApiType: %s", new Object[]{Plugin.ApiType.PLUGIN}));
        }
        try {
            this.sysModule = ServerPlugin.load(sysName, classLoader);
            this.sshModule = ServerPlugin.load(sshName, classLoader);
            this.httpModule = ServerPlugin.load(httpName, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidPluginException("Unable to load plugin Guice Modules", e);
        }
    }

    protected static Class<? extends Module> load(String name, ClassLoader pluginLoader) throws ClassNotFoundException {
        if (Strings.isNullOrEmpty(name)) {
            return null;
        }
        Class<?> clazz = Class.forName(name, false, pluginLoader);
        if (!Module.class.isAssignableFrom(clazz)) {
            throw new ClassCastException(String.format("Class %s does not implement %s", name, Module.class.getName()));
        }
        return clazz;
    }

    Path getDataDir() {
        return this.dataDir;
    }

    String getPluginCanonicalWebUrl() {
        return this.pluginCanonicalWebUrl;
    }

    String getMetricsPrefix() {
        return this.metricsPrefix;
    }

    private static Manifest getPluginManifest(PluginContentScanner scanner) throws InvalidPluginException {
        try {
            return scanner.getManifest();
        }
        catch (IOException e) {
            throw new InvalidPluginException("Cannot get plugin manifest", e);
        }
    }

    @Override
    @Nullable
    public String getVersion() {
        Attributes main = this.manifest.getMainAttributes();
        return main.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
    }

    @Override
    protected boolean canReload() {
        Attributes main = this.manifest.getMainAttributes();
        String v = main.getValue("Gerrit-ReloadMode");
        if (Strings.isNullOrEmpty(v) || "reload".equalsIgnoreCase(v)) {
            return true;
        }
        if ("restart".equalsIgnoreCase(v)) {
            return false;
        }
        log.warn("Plugin {} has invalid Gerrit-ReloadMode {}; assuming restart", (Object)this.getName(), (Object)v);
        return false;
    }

    @Override
    protected void start(PluginGuiceEnvironment env) throws Exception {
        RequestContext oldContext = env.enter(this);
        try {
            this.startPlugin(env);
        }
        finally {
            env.exit(oldContext);
        }
    }

    private void startPlugin(PluginGuiceEnvironment env) throws Exception {
        ArrayList<Module> modules;
        Injector root = this.newRootInjector(env);
        this.serverManager = new LifecycleManager();
        this.serverManager.add(root);
        AutoRegisterModules auto = null;
        if (this.sysModule == null && this.sshModule == null && this.httpModule == null) {
            auto = new AutoRegisterModules(this.getName(), env, this.scanner, this.classLoader);
            auto.discover();
        }
        if (this.sysModule != null) {
            this.sysInjector = root.createChildInjector(root.getInstance(this.sysModule));
            this.serverManager.add(this.sysInjector);
        } else if (auto != null && auto.sysModule != null) {
            this.sysInjector = root.createChildInjector(auto.sysModule);
            this.serverManager.add(this.sysInjector);
        } else {
            this.sysInjector = root;
        }
        if (env.hasSshModule()) {
            modules = new ArrayList<Module>();
            if (this.getApiType() == Plugin.ApiType.PLUGIN) {
                modules.add(env.getSshModule());
            }
            if (this.sshModule != null) {
                modules.add(this.sysInjector.getInstance(this.sshModule));
                this.sshInjector = this.sysInjector.createChildInjector(modules);
                this.serverManager.add(this.sshInjector);
            } else if (auto != null && auto.sshModule != null) {
                modules.add(auto.sshModule);
                this.sshInjector = this.sysInjector.createChildInjector(modules);
                this.serverManager.add(this.sshInjector);
            }
        }
        if (env.hasHttpModule()) {
            modules = new ArrayList();
            if (this.getApiType() == Plugin.ApiType.PLUGIN) {
                modules.add(env.getHttpModule());
            }
            if (this.httpModule != null) {
                modules.add(this.sysInjector.getInstance(this.httpModule));
                this.httpInjector = this.sysInjector.createChildInjector(modules);
                this.serverManager.add(this.httpInjector);
            } else if (auto != null && auto.httpModule != null) {
                modules.add(auto.httpModule);
                this.httpInjector = this.sysInjector.createChildInjector(modules);
                this.serverManager.add(this.httpInjector);
            }
        }
        this.serverManager.start();
    }

    private Injector newRootInjector(PluginGuiceEnvironment env) {
        ArrayList<Module> modules = Lists.newArrayListWithCapacity(2);
        if (this.getApiType() == Plugin.ApiType.PLUGIN) {
            modules.add(env.getSysModule());
        }
        modules.add(new ServerPluginInfoModule(this, env.getServerMetrics()));
        return Guice.createInjector(modules);
    }

    @Override
    protected void stop(PluginGuiceEnvironment env) {
        if (this.serverManager != null) {
            RequestContext oldContext = env.enter(this);
            try {
                this.serverManager.stop();
            }
            finally {
                env.exit(oldContext);
            }
            this.serverManager = null;
            this.sysInjector = null;
            this.sshInjector = null;
            this.httpInjector = null;
        }
    }

    @Override
    public Injector getSysInjector() {
        return this.sysInjector;
    }

    @Override
    @Nullable
    public Injector getSshInjector() {
        return this.sshInjector;
    }

    @Override
    @Nullable
    public Injector getHttpInjector() {
        return this.httpInjector;
    }

    @Override
    public void add(RegistrationHandle handle) {
        if (this.serverManager != null) {
            if (handle instanceof ReloadableRegistrationHandle) {
                if (this.reloadableHandles == null) {
                    this.reloadableHandles = new ArrayList();
                }
                this.reloadableHandles.add((ReloadableRegistrationHandle)handle);
            }
            this.serverManager.add(handle);
        }
    }

    @Override
    public PluginContentScanner getContentScanner() {
        return this.scanner;
    }
}

