/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.server.plugins.InvalidPluginException;
import com.google.gerrit.server.plugins.MultipleProvidersForPluginException;
import com.google.gerrit.server.plugins.ServerPlugin;
import com.google.gerrit.server.plugins.ServerPluginProvider;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class UniversalServerPluginProvider
implements ServerPluginProvider {
    private static final Logger log = LoggerFactory.getLogger(UniversalServerPluginProvider.class);
    private final DynamicSet<ServerPluginProvider> serverPluginProviders;

    @Inject
    UniversalServerPluginProvider(DynamicSet<ServerPluginProvider> sf) {
        this.serverPluginProviders = sf;
    }

    @Override
    public ServerPlugin get(Path srcPath, FileSnapshot snapshot, ServerPluginProvider.PluginDescription pluginDescription) throws InvalidPluginException {
        return this.providerOf(srcPath).get(srcPath, snapshot, pluginDescription);
    }

    @Override
    public String getPluginName(Path srcPath) {
        return this.providerOf(srcPath).getPluginName(srcPath);
    }

    @Override
    public boolean handles(Path srcPath) {
        List<ServerPluginProvider> providers = this.providersForHandlingPlugin(srcPath);
        switch (providers.size()) {
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        throw new MultipleProvidersForPluginException(srcPath, providers);
    }

    @Override
    public String getProviderPluginName() {
        return "gerrit";
    }

    private ServerPluginProvider providerOf(Path srcPath) {
        List<ServerPluginProvider> providers = this.providersForHandlingPlugin(srcPath);
        switch (providers.size()) {
            case 1: {
                return providers.get(0);
            }
            case 0: {
                throw new IllegalArgumentException("No ServerPluginProvider found/loaded to handle plugin file " + srcPath.toAbsolutePath());
            }
        }
        throw new MultipleProvidersForPluginException(srcPath, providers);
    }

    private List<ServerPluginProvider> providersForHandlingPlugin(Path srcPath) {
        ArrayList<ServerPluginProvider> providers = new ArrayList<ServerPluginProvider>();
        for (ServerPluginProvider serverPluginProvider : this.serverPluginProviders) {
            boolean handles = serverPluginProvider.handles(srcPath);
            log.debug("File {} handled by {} ? => {}", srcPath, serverPluginProvider.getProviderPluginName(), handles);
            if (!handles) continue;
            providers.add(serverPluginProvider);
        }
        return providers;
    }
}

