/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.api.projects.DashboardInfo;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.ProjectPermission;
import com.google.gerrit.server.permissions.RefPermission;
import com.google.gerrit.server.project.DashboardsCollection;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.BlobBasedConfig;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListDashboards
implements RestReadView<ProjectResource> {
    private static final Logger log = LoggerFactory.getLogger(ListDashboards.class);
    private final GitRepositoryManager gitManager;
    private final PermissionBackend permissionBackend;
    private final Provider<CurrentUser> user;
    @Option(name="--inherited", usage="include inherited dashboards")
    private boolean inherited;

    @Inject
    ListDashboards(GitRepositoryManager gitManager, PermissionBackend permissionBackend, Provider<CurrentUser> user) {
        this.gitManager = gitManager;
        this.permissionBackend = permissionBackend;
        this.user = user;
    }

    public List<?> apply(ProjectResource rsrc) throws ResourceNotFoundException, IOException, PermissionBackendException {
        String project = rsrc.getName();
        if (!this.inherited) {
            return this.scan(rsrc.getProjectState(), project, true);
        }
        ArrayList<List<DashboardInfo>> all = new ArrayList<List<DashboardInfo>>();
        boolean setDefault = true;
        for (ProjectState ps : this.tree(rsrc)) {
            List<DashboardInfo> list = this.scan(ps, project, setDefault);
            for (DashboardInfo d : list) {
                if (d.isDefault == null || !Boolean.TRUE.equals(d.isDefault)) continue;
                setDefault = false;
            }
            if (list.isEmpty()) continue;
            all.add(list);
        }
        return all;
    }

    private Collection<ProjectState> tree(ProjectResource rsrc) throws PermissionBackendException {
        LinkedHashMap<Project.NameKey, ProjectState> tree = new LinkedHashMap<Project.NameKey, ProjectState>();
        for (ProjectState ps : rsrc.getProjectState().tree()) {
            tree.put(ps.getNameKey(), ps);
        }
        tree.keySet().retainAll(this.permissionBackend.user(this.user).filter(ProjectPermission.ACCESS, tree.keySet()));
        return tree.values();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<DashboardInfo> scan(ProjectState state, String project, boolean setDefault) throws ResourceNotFoundException, IOException, PermissionBackendException {
        PermissionBackend.ForProject perm = this.permissionBackend.user(this.user).project(state.getNameKey());
        try {
            Throwable throwable = null;
            try (Repository git = this.gitManager.openRepository(state.getNameKey());){
                ArrayList<DashboardInfo> arrayList;
                RevWalk rw = new RevWalk(git);
                Throwable throwable2 = null;
                try {
                    ArrayList<DashboardInfo> all = new ArrayList<DashboardInfo>();
                    for (Ref ref : git.getRefDatabase().getRefs("refs/meta/dashboards/").values()) {
                        if (!perm.ref(ref.getName()).test(RefPermission.READ)) continue;
                        all.addAll(this.scanDashboards(state.getProject(), git, rw, ref, project, setDefault));
                    }
                    arrayList = all;
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            ListDashboards.$closeResource(throwable2, rw);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                ListDashboards.$closeResource(throwable2, rw);
                return arrayList;
            }
        }
        catch (RepositoryNotFoundException e) {
            throw new ResourceNotFoundException();
        }
    }

    private List<DashboardInfo> scanDashboards(Project definingProject, Repository git, RevWalk rw, Ref ref, String project, boolean setDefault) throws IOException {
        ArrayList<DashboardInfo> list = new ArrayList<DashboardInfo>();
        try (TreeWalk tw = new TreeWalk(rw.getObjectReader());){
            tw.addTree(rw.parseTree(ref.getObjectId()));
            tw.setRecursive(true);
            while (tw.next()) {
                if (tw.getFileMode(0) != FileMode.REGULAR_FILE) continue;
                try {
                    list.add(DashboardsCollection.parse(definingProject, ref.getName().substring("refs/meta/dashboards/".length()), tw.getPathString(), new BlobBasedConfig(null, git, tw.getObjectId(0)), project, setDefault));
                }
                catch (ConfigInvalidException e) {
                    log.warn("Cannot parse dashboard {}:{}:{}: {}", definingProject.getName(), ref.getName(), tw.getPathString(), e.getMessage());
                }
            }
        }
        return list;
    }
}

