/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.git.validators.RefOperationValidators;
import com.google.gerrit.server.validators.ValidationException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.transport.ReceiveCommand;

public class RefValidationHelper {
    private final RefOperationValidators.Factory refValidatorsFactory;
    private final ReceiveCommand.Type operationType;

    @Inject
    RefValidationHelper(RefOperationValidators.Factory refValidatorsFactory, @Assisted ReceiveCommand.Type operationType) {
        this.refValidatorsFactory = refValidatorsFactory;
        this.operationType = operationType;
    }

    public void validateRefOperation(String projectName, IdentifiedUser user, RefUpdate update) throws ResourceConflictException {
        RefOperationValidators refValidators = this.refValidatorsFactory.create(new Project(new Project.NameKey(projectName)), user, RefOperationValidators.getCommand(update, this.operationType));
        try {
            refValidators.validateForRefOperation();
        }
        catch (ValidationException e) {
            throw new ResourceConflictException(e.getMessage());
        }
    }

    public static interface Factory {
        public RefValidationHelper create(ReceiveCommand.Type var1);
    }
}

