/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.TimestampRangeChangePredicate;
import com.google.gwtorm.server.OrmException;
import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;

public class AgePredicate
extends TimestampRangeChangePredicate {
    protected final long cut;

    public AgePredicate(String value) {
        super(ChangeField.UPDATED, "age", value);
        long s = ConfigUtil.getTimeUnit(this.getValue(), 0L, TimeUnit.SECONDS);
        long ms = TimeUnit.MILLISECONDS.convert(s, TimeUnit.SECONDS);
        this.cut = TimeUtil.nowMs() - ms;
    }

    @Override
    public Timestamp getMinTimestamp() {
        return new Timestamp(0L);
    }

    @Override
    public Timestamp getMaxTimestamp() {
        return new Timestamp(this.cut);
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        Change change = object.change();
        return change != null && change.getLastUpdatedOn().getTime() <= this.cut;
    }
}

