/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.index.FieldDef;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeIndexPredicate;
import com.google.gwtorm.server.OrmException;

public class CommitPredicate
extends ChangeIndexPredicate {
    static FieldDef<ChangeData, ?> commitField(String id) {
        if (id.length() == 40) {
            return ChangeField.EXACT_COMMIT;
        }
        return ChangeField.COMMIT;
    }

    public CommitPredicate(String id) {
        super(CommitPredicate.commitField(id), id);
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        String id = this.getValue().toLowerCase();
        for (PatchSet p : object.patchSets()) {
            if (!this.equals(p, id)) continue;
            return true;
        }
        return false;
    }

    protected boolean equals(PatchSet p, String id) {
        boolean exact = this.getField() == ChangeField.EXACT_COMMIT;
        String rev = p.getRevision() != null ? p.getRevision().get() : null;
        return exact && id.equals(rev) || !exact && rev != null && rev.startsWith(id);
    }

    @Override
    public int getCost() {
        return 1;
    }
}

