/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.server.change.HashtagsUtil;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeIndexPredicate;
import com.google.gwtorm.server.OrmException;

public class HashtagPredicate
extends ChangeIndexPredicate {
    public HashtagPredicate(String hashtag) {
        super(ChangeField.HASHTAG, HashtagsUtil.cleanupHashtag(hashtag));
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        for (String hashtag : ((ChangeNotes)object.notes().load()).getHashtags()) {
            if (!hashtag.equalsIgnoreCase(this.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getCost() {
        return 1;
    }
}

