/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.group;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.gerrit.index.IndexConfig;
import com.google.gerrit.index.query.InternalQuery;
import com.google.gerrit.index.query.Predicate;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.group.InternalGroup;
import com.google.gerrit.server.index.group.GroupIndexCollection;
import com.google.gerrit.server.query.group.GroupPredicates;
import com.google.gerrit.server.query.group.GroupQueryProcessor;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalGroupQuery
extends InternalQuery<InternalGroup> {
    private static final Logger log = LoggerFactory.getLogger(InternalGroupQuery.class);

    @Inject
    InternalGroupQuery(GroupQueryProcessor queryProcessor, GroupIndexCollection indexes, IndexConfig indexConfig) {
        super(queryProcessor, indexes, indexConfig);
    }

    public Optional<InternalGroup> byName(AccountGroup.NameKey groupName) throws OrmException {
        return this.getOnlyGroup(GroupPredicates.name(groupName.get()), "group name '" + groupName + "'");
    }

    public Optional<InternalGroup> byId(AccountGroup.Id groupId) throws OrmException {
        return this.getOnlyGroup(GroupPredicates.id(groupId), "group id '" + groupId + "'");
    }

    public List<InternalGroup> byMember(Account.Id memberId) throws OrmException {
        return this.query(GroupPredicates.member(memberId));
    }

    public List<InternalGroup> bySubgroup(AccountGroup.UUID subgroupId) throws OrmException {
        return this.query(GroupPredicates.subgroup(subgroupId));
    }

    private Optional<InternalGroup> getOnlyGroup(Predicate<InternalGroup> predicate, String groupDescription) throws OrmException {
        List<InternalGroup> groups = this.query(predicate);
        if (groups.isEmpty()) {
            return Optional.empty();
        }
        if (groups.size() == 1) {
            return Optional.of(Iterables.getOnlyElement(groups));
        }
        ImmutableList groupUuids = groups.stream().map(InternalGroup::getGroupUUID).collect(ImmutableList.toImmutableList());
        log.warn("Ambiguous {} for groups {}.", (Object)groupDescription, (Object)groupUuids);
        return Optional.empty();
    }
}

