/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.extensions.persistence.DataSourceInterceptor;
import com.google.gerrit.metrics.CallbackMetric1;
import com.google.gerrit.metrics.Description;
import com.google.gerrit.metrics.Field;
import com.google.gerrit.metrics.MetricMaker;
import com.google.gerrit.server.config.ConfigSection;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.ThreadSettingsConfig;
import com.google.gerrit.server.schema.DataSourceType;
import com.google.gwtorm.jdbc.SimpleDataSource;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Singleton;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.eclipse.jgit.lib.Config;

@Singleton
public class DataSourceProvider
implements Provider<DataSource>,
LifecycleListener {
    private static final String DATABASE_KEY = "database";
    private final Config cfg;
    private final MetricMaker metrics;
    private final Context ctx;
    private final DataSourceType dst;
    private final ThreadSettingsConfig threadSettingsConfig;
    private DataSource ds;

    @Inject
    protected DataSourceProvider(@GerritServerConfig Config cfg, MetricMaker metrics, ThreadSettingsConfig threadSettingsConfig, Context ctx, DataSourceType dst) {
        this.cfg = cfg;
        this.metrics = metrics;
        this.threadSettingsConfig = threadSettingsConfig;
        this.ctx = ctx;
        this.dst = dst;
    }

    @Override
    public synchronized DataSource get() {
        if (this.ds == null) {
            this.ds = this.open(this.cfg, this.ctx, this.dst);
        }
        return this.ds;
    }

    @Override
    public void start() {
    }

    @Override
    public synchronized void stop() {
        if (this.ds instanceof BasicDataSource) {
            try {
                ((BasicDataSource)this.ds).close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private DataSource open(Config cfg, Context context, DataSourceType dst) {
        String url;
        ConfigSection dbs = new ConfigSection(cfg, DATABASE_KEY);
        String driver = dbs.optional("driver");
        if (Strings.isNullOrEmpty(driver)) {
            driver = dst.getDriver();
        }
        if (Strings.isNullOrEmpty(url = dbs.optional("url"))) {
            url = dst.getUrl();
        }
        String username = dbs.optional("username");
        String password = dbs.optional("password");
        String interceptor = dbs.optional("dataSourceInterceptorClass");
        boolean usePool = context == Context.SINGLE_USER ? false : cfg.getBoolean(DATABASE_KEY, "connectionpool", dst.usePool());
        if (usePool) {
            BasicDataSource lds = new BasicDataSource();
            lds.setDriverClassName(driver);
            lds.setUrl(url);
            if (username != null && !username.isEmpty()) {
                lds.setUsername(username);
            }
            if (password != null && !password.isEmpty()) {
                lds.setPassword(password);
            }
            int poolLimit = this.threadSettingsConfig.getDatabasePoolLimit();
            lds.setMaxActive(poolLimit);
            lds.setMinIdle(cfg.getInt(DATABASE_KEY, "poolminidle", 4));
            lds.setMaxIdle(cfg.getInt(DATABASE_KEY, "poolmaxidle", Math.min(poolLimit, 16)));
            lds.setMaxWait(ConfigUtil.getTimeUnit(cfg, DATABASE_KEY, null, "poolmaxwait", TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS), TimeUnit.MILLISECONDS));
            lds.setInitialSize(lds.getMinIdle());
            long evictIdleTimeMs = 60000L;
            lds.setMinEvictableIdleTimeMillis(evictIdleTimeMs);
            lds.setTimeBetweenEvictionRunsMillis(evictIdleTimeMs / 2L);
            lds.setTestOnBorrow(true);
            lds.setTestOnReturn(true);
            lds.setValidationQuery(dst.getValidationQuery());
            lds.setValidationQueryTimeout(5);
            this.exportPoolMetrics(lds);
            return this.intercept(interceptor, lds);
        }
        try {
            Properties p = new Properties();
            p.setProperty("driver", driver);
            p.setProperty("url", url);
            if (username != null) {
                p.setProperty("user", username);
            }
            if (password != null) {
                p.setProperty("password", password);
            }
            return this.intercept(interceptor, new SimpleDataSource(p));
        }
        catch (SQLException se) {
            throw new ProvisionException("Database unavailable", se);
        }
    }

    private void exportPoolMetrics(BasicDataSource pool) {
        CallbackMetric1<Boolean, Integer> cnt = this.metrics.newCallbackMetric("sql/connection_pool/connections", Integer.class, new Description("SQL database connections").setGauge().setUnit("connections"), Field.ofBoolean("active"));
        this.metrics.newTrigger(cnt, () -> {
            BasicDataSource basicDataSource = pool;
            synchronized (basicDataSource) {
                cnt.set(true, pool.getNumActive());
                cnt.set(false, pool.getNumIdle());
            }
        });
    }

    private DataSource intercept(String interceptor, DataSource ds) {
        if (interceptor == null) {
            return ds;
        }
        try {
            Constructor<?> c = Class.forName(interceptor).getConstructor(new Class[0]);
            DataSourceInterceptor datasourceInterceptor = (DataSourceInterceptor)c.newInstance(new Object[0]);
            return datasourceInterceptor.intercept("reviewDb", ds);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ProvisionException("Cannot intercept datasource", e);
        }
    }

    public static enum Context {
        SINGLE_USER,
        MULTI_USER;

    }
}

