/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.config.ThreadSettingsConfig;
import com.google.gerrit.server.schema.JdbcAccountPatchReviewStore;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.sql.SQLException;
import org.eclipse.jgit.lib.Config;

@Singleton
public class MariaDBAccountPatchReviewStore
extends JdbcAccountPatchReviewStore {
    @Inject
    MariaDBAccountPatchReviewStore(@GerritServerConfig Config cfg, SitePaths sitePaths, ThreadSettingsConfig threadSettingsConfig) {
        super(cfg, sitePaths, threadSettingsConfig);
    }

    @Override
    public OrmException convertError(String op, SQLException err) {
        switch (MariaDBAccountPatchReviewStore.getSQLStateInt(err)) {
            case 1022: 
            case 1062: 
            case 1169: {
                return new OrmDuplicateKeyException("ACCOUNT_PATCH_REVIEWS", err);
            }
        }
        if (err.getCause() == null && err.getNextException() != null) {
            err.initCause(err.getNextException());
        }
        return new OrmException(op + " failure on ACCOUNT_PATCH_REVIEWS", err);
    }
}

