/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.account.externalids.ExternalId;
import com.google.gerrit.server.account.externalids.ExternalIdReader;
import com.google.gerrit.server.account.externalids.ExternalIdsUpdate;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_143;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.RevWalk;

public class Schema_144
extends SchemaVersion {
    private static final String COMMIT_MSG = "Import external IDs from ReviewDb";
    private final GitRepositoryManager repoManager;
    private final AllUsersName allUsersName;
    private final PersonIdent serverIdent;

    @Inject
    Schema_144(Provider<Schema_143> prior, GitRepositoryManager repoManager, AllUsersName allUsersName, @GerritPersonIdent PersonIdent serverIdent) {
        super(prior);
        this.repoManager = repoManager;
        this.allUsersName = allUsersName;
        this.serverIdent = serverIdent;
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException, SQLException {
        Throwable throwable;
        HashSet<ExternalId> toAdd = new HashSet<ExternalId>();
        try (Statement stmt = ((JdbcSchema)((Object)db)).getConnection().createStatement();){
            throwable = null;
            try (ResultSet rs = stmt.executeQuery("SELECT account_id, email_address, password, external_id FROM account_external_ids");){
                while (rs.next()) {
                    Account.Id accountId = new Account.Id(rs.getInt(1));
                    String email = rs.getString(2);
                    String password = rs.getString(3);
                    String externalId = rs.getString(4);
                    toAdd.add(ExternalId.create(ExternalId.Key.parse(externalId), accountId, email, password));
                }
            }
            catch (Throwable accountId) {
                throwable = accountId;
                throw accountId;
            }
        }
        try {
            var5_6 = null;
            try (Repository repo = this.repoManager.openRepository(this.allUsersName);){
                throwable = null;
                try (RevWalk rw = new RevWalk(repo);
                     ObjectInserter ins = repo.newObjectInserter();){
                    ObjectId rev = ExternalIdReader.readRevision(repo);
                    NoteMap noteMap = ExternalIdReader.readNoteMap(rw, rev);
                    for (ExternalId extId : toAdd) {
                        ExternalIdsUpdate.upsert(rw, ins, noteMap, extId);
                    }
                    ExternalIdsUpdate.commit(this.allUsersName, repo, rw, ins, rev, noteMap, COMMIT_MSG, this.serverIdent, this.serverIdent, null, GitReferenceUpdated.DISABLED);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                var5_6 = throwable3;
                throw throwable3;
            }
        }
        catch (IOException | ConfigInvalidException e) {
            throw new OrmException("Failed to migrate external IDs to NoteDb", e);
        }
    }
}

