/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.securestore;

import com.google.common.base.Strings;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.SiteLibraryLoaderUtil;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.securestore.DefaultSecureStore;
import com.google.gerrit.server.securestore.SecureStore;
import com.google.gerrit.server.securestore.SecureStoreClassName;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SecureStoreProvider
implements Provider<SecureStore> {
    private static final Logger log = LoggerFactory.getLogger(SecureStoreProvider.class);
    private final Path libdir;
    private final Injector injector;
    private final String className;

    @Inject
    protected SecureStoreProvider(Injector injector, SitePaths sitePaths, @Nullable @SecureStoreClassName String className) {
        this.injector = injector;
        this.libdir = sitePaths.lib_dir;
        this.className = className;
    }

    @Override
    public synchronized SecureStore get() {
        return this.injector.getInstance(this.getSecureStoreImpl());
    }

    private Class<? extends SecureStore> getSecureStoreImpl() {
        if (Strings.isNullOrEmpty(this.className)) {
            return DefaultSecureStore.class;
        }
        SiteLibraryLoaderUtil.loadSiteLib(this.libdir);
        try {
            return Class.forName(this.className);
        }
        catch (ClassNotFoundException e) {
            String msg = String.format("Cannot load secure store class: %s", this.className);
            log.error(msg, e);
            throw new RuntimeException(msg, e);
        }
    }
}

