/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.tools;

import com.google.common.base.Strings;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.Version;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.util.RawParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ToolsCatalog {
    private static final Logger log = LoggerFactory.getLogger(ToolsCatalog.class);
    private final SortedMap<String, Entry> toc = ToolsCatalog.readToc();

    @Inject
    ToolsCatalog() throws IOException {
    }

    @Nullable
    public Entry get(@Nullable String name) {
        if (Strings.isNullOrEmpty(name)) {
            return null;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        return (Entry)this.toc.get(name);
    }

    private static SortedMap<String, Entry> readToc() throws IOException {
        String line;
        TreeMap<String, Entry> toc = new TreeMap<String, Entry>();
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(ToolsCatalog.read("TOC")), StandardCharsets.UTF_8));
        while ((line = br.readLine()) != null) {
            if (line.length() <= 0 || line.startsWith("#")) continue;
            Entry e = new Entry(Entry.Type.FILE, line);
            toc.put(e.getPath(), e);
        }
        ArrayList all = new ArrayList(toc.values());
        for (Entry e : all) {
            String path = ToolsCatalog.dirOf(e.getPath());
            while (path != null) {
                Entry d = (Entry)toc.get(path);
                if (d == null) {
                    d = new Entry(Entry.Type.DIR, 493, path);
                    toc.put(d.getPath(), d);
                }
                d.children.add(e);
                path = ToolsCatalog.dirOf(path);
                e = d;
            }
        }
        Entry top = new Entry(Entry.Type.DIR, 493, "");
        for (Entry e : toc.values()) {
            if (ToolsCatalog.dirOf(e.getPath()) != null) continue;
            top.children.add(e);
        }
        toc.put(top.getPath(), top);
        return Collections.unmodifiableSortedMap(toc);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static byte[] read(String path) {
        String name = "root/" + path;
        try (InputStream in = ToolsCatalog.class.getResourceAsStream(name);){
            int n;
            if (in == null) {
                byte[] byArray2 = null;
                return byArray2;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            while ((n = in.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, n);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            log.debug("Cannot read " + path, e);
            return null;
        }
    }

    @Nullable
    private static String dirOf(String path) {
        int s = path.lastIndexOf(47);
        return s < 0 ? null : path.substring(0, s);
    }

    public static class Entry {
        private final Type type;
        private final int mode;
        private final String path;
        private final List<Entry> children;

        Entry(Type type, String line) {
            int s = line.indexOf(32);
            String mode = line.substring(0, s);
            String path = line.substring(s + 1);
            this.type = type;
            this.mode = Integer.parseInt(mode, 8);
            this.path = path;
            this.children = type == Type.FILE ? Collections.emptyList() : new ArrayList<Entry>();
        }

        Entry(Type type, int mode, String path) {
            this.type = type;
            this.mode = mode;
            this.path = path;
            this.children = new ArrayList<Entry>();
        }

        public Type getType() {
            return this.type;
        }

        public int getMode() {
            return this.mode;
        }

        public String getPath() {
            return this.path;
        }

        public String getName() {
            int s = this.path.lastIndexOf(47);
            return s < 0 ? this.path : this.path.substring(s + 1);
        }

        public List<Entry> getChildren() {
            return Collections.unmodifiableList(this.children);
        }

        public byte[] getBytes() {
            byte[] data = ToolsCatalog.read(this.getPath());
            if (this.isScript(data)) {
                String version = Version.getVersion();
                int lf = RawParseUtils.nextLF(data, 0);
                if (version != null && lf < data.length) {
                    byte[] versionHeader = Constants.encode("# From Gerrit Code Review " + version + "\n");
                    ByteArrayOutputStream buf = new ByteArrayOutputStream();
                    buf.write(data, 0, lf);
                    buf.write(versionHeader, 0, versionHeader.length);
                    buf.write(data, lf, data.length - lf);
                    data = buf.toByteArray();
                }
            }
            return data;
        }

        private boolean isScript(byte[] data) {
            return data != null && data.length > 3 && data[0] == 35 && data[1] == 33 && data[2] == 47;
        }

        public static enum Type {
            DIR,
            FILE;

        }
    }
}

