/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.update;

import com.google.common.base.Preconditions;
import com.google.gerrit.server.git.RefCache;
import com.google.gerrit.server.git.RepoRefCache;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.ReceiveCommand;

public class ChainedReceiveCommands
implements RefCache {
    private final Map<String, ReceiveCommand> commands = new LinkedHashMap<String, ReceiveCommand>();
    private final RepoRefCache refCache;

    public ChainedReceiveCommands(Repository repo) {
        this(new RepoRefCache(repo));
    }

    public ChainedReceiveCommands(RepoRefCache refCache) {
        this.refCache = Preconditions.checkNotNull(refCache);
    }

    public RepoRefCache getRepoRefCache() {
        return this.refCache;
    }

    public boolean isEmpty() {
        return this.commands.isEmpty();
    }

    public void add(ReceiveCommand cmd) {
        Preconditions.checkArgument(!cmd.getOldId().equals(cmd.getNewId()), "ref update is a no-op: %s", (Object)cmd);
        ReceiveCommand old = this.commands.get(cmd.getRefName());
        if (old == null) {
            this.commands.put(cmd.getRefName(), cmd);
            return;
        }
        Preconditions.checkArgument(old.getResult() == ReceiveCommand.Result.NOT_ATTEMPTED, "cannot chain ref update %s after update %s with result %s", (Object)cmd, (Object)old, (Object)old.getResult());
        Preconditions.checkArgument(cmd.getOldId().equals(old.getNewId()), "cannot chain ref update %s after update %s with different new ID", (Object)cmd, (Object)old);
        this.commands.put(cmd.getRefName(), new ReceiveCommand(old.getOldId(), cmd.getNewId(), cmd.getRefName()));
    }

    @Override
    public Optional<ObjectId> get(String refName) throws IOException {
        ReceiveCommand cmd = this.commands.get(refName);
        if (cmd != null) {
            return !cmd.getNewId().equals(ObjectId.zeroId()) ? Optional.of(cmd.getNewId()) : Optional.empty();
        }
        return this.refCache.get(refName);
    }

    public void addTo(BatchRefUpdate bru) {
        for (ReceiveCommand cmd : this.commands.values()) {
            bru.addCommand(cmd);
        }
    }

    public Map<String, ReceiveCommand> getCommands() {
        return Collections.unmodifiableMap(this.commands);
    }
}

