/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.update;

import com.google.common.annotations.VisibleForTesting;
import com.google.gerrit.server.git.LockFailureException;
import java.io.IOException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;

public class RefUpdateUtil {
    public static void executeChecked(BatchRefUpdate bru, RevWalk rw) throws IOException {
        bru.execute(rw, NullProgressMonitor.INSTANCE);
        RefUpdateUtil.checkResults(bru);
    }

    @VisibleForTesting
    static void checkResults(BatchRefUpdate bru) throws IOException {
        int lockFailure = 0;
        int aborted = 0;
        int failure = 0;
        for (ReceiveCommand cmd : bru.getCommands()) {
            if (cmd.getResult() != ReceiveCommand.Result.OK) {
                ++failure;
            }
            if (cmd.getResult() == ReceiveCommand.Result.LOCK_FAILURE) {
                ++lockFailure;
                continue;
            }
            if (cmd.getResult() != ReceiveCommand.Result.REJECTED_OTHER_REASON || !JGitText.get().transactionAborted.equals(cmd.getMessage())) continue;
            ++aborted;
        }
        if (lockFailure + aborted == bru.getCommands().size()) {
            throw new LockFailureException("Update aborted with one or more lock failures: " + bru, bru);
        }
        if (failure > 0) {
            throw new IOException("Update failed: " + bru);
        }
    }

    private RefUpdateUtil() {
    }
}

