/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.base.Preconditions;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.util.IdGenerator;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.gerrit.sshd.SshDaemon;
import com.google.gerrit.sshd.SshSession;
import com.google.inject.Inject;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.mina.MinaAcceptor;
import org.apache.sshd.common.io.mina.MinaSession;
import org.apache.sshd.common.io.nio2.Nio2Acceptor;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.server.Environment;
import org.kohsuke.args4j.Option;

@RequiresCapability(value="viewConnections")
@CommandMetaData(name="show-connections", description="Display active client SSH connections", runsAt=CommandMetaData.Mode.MASTER_OR_SLAVE)
final class ShowConnections
extends SshCommand {
    @Option(name="--numeric", aliases={"-n"}, usage="don't resolve names")
    private boolean numeric;
    @Option(name="--wide", aliases={"-w"}, usage="display without line width truncation")
    private boolean wide;
    @Inject
    private SshDaemon daemon;
    private int hostNameWidth;
    private int columns = 80;

    ShowConnections() {
    }

    @Override
    public void start(Environment env) throws IOException {
        String s = env.getEnv().get("COLUMNS");
        if (s != null && !s.isEmpty()) {
            try {
                this.columns = Integer.parseInt(s);
            }
            catch (NumberFormatException err) {
                this.columns = 80;
            }
        }
        super.start(env);
    }

    @Override
    protected void run() throws BaseCommand.Failure {
        IoAcceptor acceptor = this.daemon.getIoAcceptor();
        if (acceptor == null) {
            throw new BaseCommand.Failure(1, "fatal: sshd no longer running");
        }
        ArrayList<IoSession> list = new ArrayList<IoSession>(acceptor.getManagedSessions().values());
        Collections.sort(list, new Comparator<IoSession>(){

            @Override
            public int compare(IoSession arg0, IoSession arg1) {
                if (arg0 instanceof MinaSession) {
                    MinaSession mArg0 = (MinaSession)arg0;
                    MinaSession mArg1 = (MinaSession)arg1;
                    if (mArg0.getSession().getCreationTime() < mArg1.getSession().getCreationTime()) {
                        return -1;
                    }
                    if (mArg0.getSession().getCreationTime() > mArg1.getSession().getCreationTime()) {
                        return 1;
                    }
                }
                return (int)(arg0.getId() - arg1.getId());
            }
        });
        int n = this.hostNameWidth = this.wide ? Integer.MAX_VALUE : this.columns - 9 - 9 - 10 - 32;
        if (this.getBackend().equals("mina")) {
            long now = TimeUtil.nowMs();
            this.stdout.print(String.format("%-8s %8s %8s   %-15s %s\n", "Session", "Start", "Idle", "User", "Remote Host"));
            this.stdout.print("--------------------------------------------------------------\n");
            for (IoSession io : list) {
                Preconditions.checkState(io instanceof MinaSession, "expected MinaSession");
                MinaSession minaSession = (MinaSession)io;
                long start = minaSession.getSession().getCreationTime();
                long idle = now - minaSession.getSession().getLastIoTime();
                AbstractSession s = AbstractSession.getSession(io, true);
                SshSession sd = s != null ? s.getAttribute(SshSession.KEY) : null;
                this.stdout.print(String.format("%8s %8s %8s   %-15.15s %s\n", ShowConnections.id(sd), ShowConnections.time(now, start), ShowConnections.age(idle), this.username(sd), this.hostname(io.getRemoteAddress())));
            }
        } else {
            this.stdout.print(String.format("%-8s   %-15s %s\n", "Session", "User", "Remote Host"));
            this.stdout.print("--------------------------------------------------------------\n");
            for (IoSession io : list) {
                AbstractSession s = AbstractSession.getSession(io, true);
                SshSession sd = s != null ? s.getAttribute(SshSession.KEY) : null;
                this.stdout.print(String.format("%8s   %-15.15s %s\n", ShowConnections.id(sd), this.username(sd), this.hostname(io.getRemoteAddress())));
            }
        }
        this.stdout.print("--\n");
        this.stdout.print("SSHD Backend: " + this.getBackend() + "\n");
    }

    private String getBackend() {
        IoAcceptor acceptor = this.daemon.getIoAcceptor();
        if (acceptor == null) {
            return "";
        }
        if (acceptor instanceof MinaAcceptor) {
            return "mina";
        }
        if (acceptor instanceof Nio2Acceptor) {
            return "nio2";
        }
        return "unknown";
    }

    private static String id(SshSession sd) {
        return sd != null ? IdGenerator.format(sd.getSessionId()) : "";
    }

    private static String time(long now, long time) {
        if (now - time < 86400000L) {
            return new SimpleDateFormat("HH:mm:ss").format(new Date(time));
        }
        return new SimpleDateFormat("MMM-dd").format(new Date(time));
    }

    private static String age(long age) {
        int sec = (int)((age /= 1000L) % 60L);
        int min = (int)((age /= 60L) % 60L);
        int hr = (int)((age /= 60L) % 60L);
        return String.format("%02d:%02d:%02d", hr, min, sec);
    }

    private String username(SshSession sd) {
        if (sd == null) {
            return "";
        }
        CurrentUser user = sd.getUser();
        if (user != null && user.isIdentifiedUser()) {
            String name;
            IdentifiedUser u = user.asIdentifiedUser();
            if (!this.numeric && (name = u.getAccount().getUserName()) != null && !name.isEmpty()) {
                return name;
            }
            return "a/" + u.getAccountId().toString();
        }
        return "";
    }

    private String hostname(SocketAddress remoteAddress) {
        if (remoteAddress == null) {
            return "?";
        }
        String host = null;
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress sa = (InetSocketAddress)remoteAddress;
            InetAddress in = sa.getAddress();
            if (this.numeric) {
                return in.getHostAddress();
            }
            host = in != null ? in.getCanonicalHostName() : sa.getHostName();
        }
        if (host == null) {
            host = remoteAddress.toString();
        }
        if (host.length() > this.hostNameWidth) {
            return host.substring(0, this.hostNameWidth);
        }
        return host;
    }
}

