/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtjsonrpc.rebind;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsonUtils;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JArrayType;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JPackage;
import com.google.gwt.core.ext.typeinfo.JParameter;
import com.google.gwt.core.ext.typeinfo.JParameterizedType;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.dev.generator.NameFactory;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import com.google.gwtjsonrpc.client.CallbackHandle;
import com.google.gwtjsonrpc.client.JsonUtil;
import com.google.gwtjsonrpc.client.impl.AbstractJsonProxy;
import com.google.gwtjsonrpc.client.impl.JsonSerializer;
import com.google.gwtjsonrpc.client.impl.ResultDeserializer;
import com.google.gwtjsonrpc.client.impl.v1_1.JsonCall11HttpPost;
import com.google.gwtjsonrpc.client.impl.v2_0.JsonCall20HttpGet;
import com.google.gwtjsonrpc.client.impl.v2_0.JsonCall20HttpPost;
import com.google.gwtjsonrpc.common.AsyncCallback;
import com.google.gwtjsonrpc.common.HostPageCache;
import com.google.gwtjsonrpc.common.RpcImpl;
import com.google.gwtjsonrpc.rebind.ResultDeserializerCreator;
import com.google.gwtjsonrpc.rebind.SerializerCreator;
import java.io.PrintWriter;
import java.util.HashSet;

class ProxyCreator {
    private static final String PROXY_SUFFIX = "_JsonProxy";
    private JClassType svcInf;
    private JClassType asyncCallbackClass;
    private SerializerCreator serializerCreator;
    private ResultDeserializerCreator deserializerCreator;
    private int instanceField;

    ProxyCreator(JClassType remoteService) {
        this.svcInf = remoteService;
    }

    String create(TreeLogger logger, GeneratorContext context) throws UnableToCompleteException {
        this.serializerCreator = new SerializerCreator(context);
        this.deserializerCreator = new ResultDeserializerCreator(context, this.serializerCreator);
        TypeOracle typeOracle = context.getTypeOracle();
        try {
            this.asyncCallbackClass = typeOracle.getType(AsyncCallback.class.getName());
        }
        catch (NotFoundException e) {
            logger.log(TreeLogger.ERROR, null, (Throwable)e);
            throw new UnableToCompleteException();
        }
        this.checkMethods(logger);
        SourceWriter srcWriter = this.getSourceWriter(logger, context);
        if (srcWriter == null) {
            return this.getProxyQualifiedName();
        }
        this.generateProxyConstructor(srcWriter);
        this.generateProxyCallCreator(logger, srcWriter);
        this.generateProxyMethods(srcWriter);
        srcWriter.commit(logger);
        return this.getProxyQualifiedName();
    }

    private void checkMethods(TreeLogger logger) throws UnableToCompleteException {
        JMethod[] methodList;
        HashSet<String> declaredNames = new HashSet<String>();
        for (JMethod m : methodList = this.svcInf.getOverridableMethods()) {
            JParameter callback;
            JParameter[] params;
            if (!declaredNames.add(m.getName())) {
                this.invalid(logger, "Overloading method " + m.getName() + " not supported");
            }
            if (m.getReturnType() != JPrimitiveType.VOID && !this.returnsCallbackHandle(m)) {
                this.invalid(logger, "Method " + m.getName() + " must return void or " + CallbackHandle.class);
            }
            if ((params = m.getParameters()).length == 0) {
                this.invalid(logger, "Method " + m.getName() + " requires " + AsyncCallback.class.getName() + " as last parameter");
            }
            if (!(callback = params[params.length - 1]).getType().getErasedType().getQualifiedSourceName().equals(this.asyncCallbackClass.getQualifiedSourceName())) {
                this.invalid(logger, "Method " + m.getName() + " requires " + AsyncCallback.class.getName() + " as last parameter");
            }
            if (callback.getType().isParameterized() == null) {
                this.invalid(logger, "Callback " + callback.getName() + " must have a type parameter");
            }
            JClassType resultType = callback.getType().isParameterized().getTypeArgs()[0];
            if (this.returnsCallbackHandle(m)) {
                JClassType rt;
                if (params.length != 1) {
                    this.invalid(logger, "Method " + m.getName() + " must not accept parameters");
                }
                if ((rt = m.getReturnType().isClass()).isParameterized() == null) {
                    this.invalid(logger, "CallbackHandle return value of " + m.getName() + " must have a type parameter");
                }
                if (!resultType.getQualifiedSourceName().equals(rt.isParameterized().getTypeArgs()[0].getQualifiedSourceName())) {
                    this.invalid(logger, "CallbackHandle return value of " + m.getName() + " must match type with AsyncCallback parameter");
                }
            }
            if (m.getAnnotation(HostPageCache.class) != null) {
                if (m.getReturnType() != JPrimitiveType.VOID) {
                    this.invalid(logger, "Method " + m.getName() + " must return void if using " + HostPageCache.class.getName());
                }
                if (params.length != 1) {
                    this.invalid(logger, "Method " + m.getName() + " must not accept parameters");
                }
            }
            for (int i = 0; i < params.length - 1; ++i) {
                JParameter p = params[i];
                TreeLogger branch = logger.branch(TreeLogger.DEBUG, m.getName() + ", parameter " + p.getName());
                this.serializerCreator.checkCanSerialize(branch, p.getType());
                if (p.getType().isPrimitive() != null || SerializerCreator.isBoxedPrimitive(p.getType())) continue;
                this.serializerCreator.create((JClassType)p.getType(), branch);
            }
            TreeLogger branch = logger.branch(TreeLogger.DEBUG, m.getName() + ", result " + resultType.getQualifiedSourceName());
            this.serializerCreator.checkCanSerialize(branch, (JType)resultType);
            if (resultType.isArray() != null) {
                this.deserializerCreator.create(branch, resultType.isArray());
                continue;
            }
            if (resultType.isPrimitive() != null || SerializerCreator.isBoxedPrimitive((JType)resultType)) continue;
            this.serializerCreator.create(resultType, branch);
        }
    }

    private boolean returnsCallbackHandle(JMethod m) {
        return m.getReturnType().getErasedType().getQualifiedSourceName().equals(CallbackHandle.class.getName());
    }

    private void invalid(TreeLogger logger, String what) throws UnableToCompleteException {
        logger.log(TreeLogger.ERROR, what, null);
        throw new UnableToCompleteException();
    }

    private SourceWriter getSourceWriter(TreeLogger logger, GeneratorContext ctx) {
        JPackage servicePkg = this.svcInf.getPackage();
        String pkgName = servicePkg == null ? "" : servicePkg.getName();
        PrintWriter pw = ctx.tryCreate(logger, pkgName, this.getProxySimpleName());
        if (pw == null) {
            return null;
        }
        ClassSourceFileComposerFactory cf = new ClassSourceFileComposerFactory(pkgName, this.getProxySimpleName());
        cf.addImport(AbstractJsonProxy.class.getCanonicalName());
        cf.addImport(JsonSerializer.class.getCanonicalName());
        cf.addImport(JsonUtils.class.getCanonicalName());
        cf.addImport(JavaScriptObject.class.getCanonicalName());
        cf.addImport(ResultDeserializer.class.getCanonicalName());
        cf.addImport(AsyncCallback.class.getCanonicalName());
        cf.addImport(GWT.class.getCanonicalName());
        cf.setSuperclass(AbstractJsonProxy.class.getSimpleName());
        cf.addImplementedInterface(this.svcInf.getErasedType().getQualifiedSourceName());
        return cf.createSourceWriter(ctx, pw);
    }

    private void generateProxyConstructor(SourceWriter w) {
        RemoteServiceRelativePath relPath = (RemoteServiceRelativePath)this.svcInf.getAnnotation(RemoteServiceRelativePath.class);
        if (relPath != null) {
            w.println();
            w.println("public " + this.getProxySimpleName() + "() {");
            w.indent();
            w.println("setServiceEntryPoint(GWT.getModuleBaseURL() + \"" + relPath.value() + "\");");
            w.outdent();
            w.println("}");
        }
    }

    private void generateProxyCallCreator(TreeLogger logger, SourceWriter w) throws UnableToCompleteException {
        String callName = this.getJsonCallClassName(logger);
        w.println();
        w.println("@Override");
        w.print("protected <T> ");
        w.print(callName);
        w.print("<T> newJsonCall(final AbstractJsonProxy proxy, ");
        w.print("final String methodName, final String reqData, ");
        w.println("final ResultDeserializer<T> ser, final AsyncCallback<T> cb) {");
        w.indent();
        w.print("return new ");
        w.print(callName);
        w.println("<T>(proxy, methodName, reqData, ser, cb);");
        w.outdent();
        w.println("}");
    }

    private String getJsonCallClassName(TreeLogger logger) throws UnableToCompleteException {
        RpcImpl impl = (RpcImpl)this.svcInf.getAnnotation(RpcImpl.class);
        if (impl == null) {
            return JsonCall11HttpPost.class.getCanonicalName();
        }
        if (impl.version() == RpcImpl.Version.V1_1 && impl.transport() == RpcImpl.Transport.HTTP_POST) {
            return JsonCall11HttpPost.class.getCanonicalName();
        }
        if (impl.version() == RpcImpl.Version.V2_0 && impl.transport() == RpcImpl.Transport.HTTP_POST) {
            return JsonCall20HttpPost.class.getCanonicalName();
        }
        if (impl.version() == RpcImpl.Version.V2_0 && impl.transport() == RpcImpl.Transport.HTTP_GET) {
            return JsonCall20HttpGet.class.getCanonicalName();
        }
        logger.log(TreeLogger.Type.ERROR, "Unsupported JSON-RPC version and transport combination: Supported are 1.1 over HTTP POST and 2.0 over HTTP POST and GET");
        throw new UnableToCompleteException();
    }

    private void generateProxyMethods(SourceWriter srcWriter) {
        JMethod[] methodList;
        for (JMethod m : methodList = this.svcInf.getOverridableMethods()) {
            this.generateProxyMethod(m, srcWriter);
        }
    }

    private void generateProxyMethod(JMethod method, SourceWriter w) {
        String reqDataStr;
        JParameter[] params = method.getParameters();
        JParameter callback = params[params.length - 1];
        JClassType resultType = callback.getType().isParameterized().getTypeArgs()[0];
        String[] serializerFields = new String[params.length];
        HostPageCache hpc = (HostPageCache)method.getAnnotation(HostPageCache.class);
        w.println();
        for (int i = 0; i < params.length - 1; ++i) {
            JType pType = params[i].getType();
            if (!SerializerCreator.needsTypeParameter(pType)) continue;
            serializerFields[i] = "serializer_" + this.instanceField++;
            w.print("private static final ");
            if (pType.isArray() != null) {
                w.print(this.serializerCreator.serializerFor(pType));
            } else {
                w.print(JsonSerializer.class.getName());
            }
            w.print(" ");
            w.print(serializerFields[i]);
            w.print(" = ");
            this.serializerCreator.generateSerializerReference(pType, w);
            w.println(";");
        }
        if (resultType.isParameterized() != null) {
            serializerFields[params.length - 1] = "serializer_" + this.instanceField++;
            w.print("private static final ");
            w.print(ResultDeserializer.class.getName());
            w.print(" ");
            w.print(serializerFields[params.length - 1]);
            w.print(" = ");
            this.serializerCreator.generateSerializerReference((JType)resultType, w);
            w.println(";");
        }
        w.print("public ");
        w.print(method.getReturnType().getQualifiedSourceName());
        w.print(" ");
        w.print(method.getName());
        w.print("(");
        boolean needsComma = false;
        NameFactory nameFactory = new NameFactory();
        for (int i = 0; i < params.length; ++i) {
            JParameter param = params[i];
            if (needsComma) {
                w.print(", ");
            } else {
                needsComma = true;
            }
            JType paramType = param.getType().getErasedType();
            w.print(paramType.getQualifiedSourceName());
            w.print(" ");
            nameFactory.addName(param.getName());
            w.print(param.getName());
        }
        w.println(") {");
        w.indent();
        if (this.returnsCallbackHandle(method)) {
            w.print("return new ");
            w.print(CallbackHandle.class.getName());
            w.print("(");
            if (SerializerCreator.needsTypeParameter((JType)resultType)) {
                w.print(serializerFields[params.length - 1]);
            } else {
                this.deserializerCreator.generateDeserializerReference((JType)resultType, w);
            }
            w.print(", " + callback.getName());
            w.println(");");
            w.outdent();
            w.println("}");
            return;
        }
        if (hpc != null) {
            String objName = nameFactory.createName("cached");
            w.print("final JavaScriptObject " + objName + " = ");
            w.print(AbstractJsonProxy.class.getName());
            w.print(".");
            w.print(hpc.once() ? "hostPageCacheGetOnce" : "hostPageCacheGetMany");
            w.println("(\"" + hpc.name() + "\");");
            w.println("if (" + objName + " != null) {");
            w.indent();
            w.print(JsonUtil.class.getName());
            w.print(".invoke(");
            if (SerializerCreator.needsTypeParameter((JType)resultType)) {
                w.print(serializerFields[params.length - 1]);
            } else {
                this.deserializerCreator.generateDeserializerReference((JType)resultType, w);
            }
            w.print(", " + callback.getName());
            w.print(", " + objName);
            w.println(");");
            w.println("return;");
            w.outdent();
            w.println("}");
        }
        if (params.length == 1) {
            reqDataStr = "\"[]\"";
        } else {
            String reqData = nameFactory.createName("reqData");
            w.println("final StringBuilder " + reqData + " = new StringBuilder();");
            needsComma = false;
            w.println(reqData + ".append('[');");
            for (int i = 0; i < params.length - 1; ++i) {
                if (needsComma) {
                    w.println(reqData + ".append(\",\");");
                } else {
                    needsComma = true;
                }
                JType pType = params[i].getType();
                String pName = params[i].getName();
                if (pType == JPrimitiveType.CHAR || SerializerCreator.isBoxedCharacter(pType)) {
                    w.println(reqData + ".append(" + JsonUtils.class.getSimpleName());
                    w.println(".escapeValue(String.valueOf(" + pName + ")));");
                    continue;
                }
                if ((SerializerCreator.isJsonPrimitive(pType) || SerializerCreator.isBoxedPrimitive(pType)) && !SerializerCreator.isJsonString(pType)) {
                    w.println(reqData + ".append(" + pName + ");");
                    continue;
                }
                w.println("if (" + pName + " != null) {");
                w.indent();
                if (SerializerCreator.needsTypeParameter(pType)) {
                    w.print(serializerFields[i]);
                } else {
                    this.serializerCreator.generateSerializerReference(pType, w);
                }
                w.println(".printJson(" + reqData + ", " + pName + ");");
                w.outdent();
                w.println("} else {");
                w.indent();
                w.println(reqData + ".append(" + JsonSerializer.class.getName() + ".JS_NULL);");
                w.outdent();
                w.println("}");
            }
            w.println(reqData + ".append(']');");
            reqDataStr = reqData + ".toString()";
        }
        w.print("doInvoke(");
        w.print("\"" + method.getName() + "\"");
        w.print(", " + reqDataStr);
        w.print(", ");
        if (resultType.isParameterized() != null) {
            w.print(serializerFields[params.length - 1]);
        } else {
            this.deserializerCreator.generateDeserializerReference((JType)resultType, w);
        }
        w.print(", " + callback.getName());
        w.println(");");
        w.outdent();
        w.println("}");
    }

    private String getProxyQualifiedName() {
        String[] name = ProxyCreator.synthesizeTopLevelClassName(this.svcInf, PROXY_SUFFIX);
        return name[0].length() == 0 ? name[1] : name[0] + "." + name[1];
    }

    private String getProxySimpleName() {
        return ProxyCreator.synthesizeTopLevelClassName(this.svcInf, PROXY_SUFFIX)[1];
    }

    static String[] synthesizeTopLevelClassName(JClassType type, String suffix) {
        JArrayType isArray;
        String packageName;
        String className;
        JType leafType = type.getLeafType();
        if (leafType.isPrimitive() != null) {
            className = leafType.getSimpleSourceName();
            packageName = "";
        } else {
            JClassType classOrInterface = leafType.isClassOrInterface();
            assert (classOrInterface != null);
            className = classOrInterface.getName();
            packageName = classOrInterface.getPackage().getName();
        }
        JParameterizedType isGeneric = type.isParameterized();
        if (isGeneric != null) {
            for (JClassType param : isGeneric.getTypeArgs()) {
                className = className + "_";
                className = className + param.getQualifiedSourceName().replace('.', '_');
            }
        }
        if ((isArray = type.isArray()) != null) {
            className = className + "_Array_Rank_" + isArray.getRank();
        }
        className = className + suffix;
        className = className.replace('.', '_');
        return new String[]{packageName, className};
    }
}

