/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_Conditional;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.ConditionalBuilder;
import com.google.template.soy.jssrc.dsl.Declaration;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.IfThenPair;
import javax.annotation.Nullable;

@Immutable
abstract class Conditional
extends CodeChunk {
    Conditional() {
    }

    abstract ImmutableList<IfThenPair> conditions();

    @Nullable
    abstract CodeChunk trailingElse();

    static Conditional create(ImmutableList<IfThenPair> conditions, @Nullable CodeChunk trailingElse) {
        Preconditions.checkArgument(!conditions.isEmpty());
        return new AutoValue_Conditional(conditions, trailingElse);
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
        this.formatIfClause(ctx);
        int numRightBracesToClose = 0;
        CodeChunk.WithValue firstPredicate = ((IfThenPair)this.conditions().get((int)0)).predicate;
        for (IfThenPair condition : this.conditions().subList(1, this.conditions().size())) {
            if (firstPredicate.initialStatements().containsAll(condition.predicate.initialStatements())) {
                Conditional.formatElseIfClauseWithNoDependencies(condition, ctx);
                continue;
            }
            Conditional.formatElseIfClauseWithDependencies(condition, ctx);
            ++numRightBracesToClose;
        }
        this.formatElseClause(ctx);
        for (int i = 0; i < numRightBracesToClose; ++i) {
            ctx.close();
        }
        ctx.endLine();
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        for (IfThenPair child : this.conditions()) {
            child.predicate.collectRequires(collector);
            child.consequent.collectRequires(collector);
        }
        if (this.trailingElse() != null) {
            this.trailingElse().collectRequires(collector);
        }
    }

    private void formatIfClause(FormattingContext ctx) {
        IfThenPair first = (IfThenPair)this.conditions().get(0);
        ctx.appendInitialStatements(first.predicate).append("if (").appendOutputExpression(first.predicate).append(") ");
        try (FormattingContext ignored = ctx.enterBlock();){
            ctx.appendAll(first.consequent);
        }
    }

    private static void formatElseIfClauseWithNoDependencies(IfThenPair condition, FormattingContext ctx) {
        ctx.append(" else if (").appendOutputExpression(condition.predicate).append(") ");
        try (FormattingContext ignored = ctx.enterBlock();){
            ctx.appendAll(condition.consequent);
        }
    }

    private static void formatElseIfClauseWithDependencies(IfThenPair condition, FormattingContext ctx) {
        ctx.append(" else ");
        try (FormattingContext ignored = ctx.enterBlock();){
            ctx.appendInitialStatements(condition.predicate).append("if (").appendOutputExpression(condition.predicate).append(") ");
            ctx.enterBlock();
            ctx.appendAll(condition.consequent);
        }
    }

    private void formatElseClause(FormattingContext ctx) {
        if (this.trailingElse() == null) {
            return;
        }
        ctx.append(" else ");
        try (FormattingContext ignored = ctx.enterBlock();){
            ctx.appendAll(this.trailingElse());
        }
        ctx.endLine();
    }

    private boolean everyBranchHasAValue() {
        for (IfThenPair condition : this.conditions()) {
            if (condition.consequent instanceof CodeChunk.WithValue) continue;
            return false;
        }
        return this.trailingElse() instanceof CodeChunk.WithValue;
    }

    CodeChunk.WithValue asConditionalExpression(CodeChunk.Generator codeGenerator) {
        Preconditions.checkState(this.everyBranchHasAValue());
        Declaration decl = codeGenerator.declare(CodeChunk.WithValue.LITERAL_NULL);
        CodeChunk.WithValue var = decl.ref();
        ConditionalBuilder builder = null;
        for (IfThenPair oldCondition : this.conditions()) {
            CodeChunk.WithValue newConsequent = var.assign((CodeChunk.WithValue)oldCondition.consequent);
            if (builder == null) {
                builder = CodeChunk.ifStatement(oldCondition.predicate, newConsequent);
                continue;
            }
            builder.elseif_(oldCondition.predicate, newConsequent);
        }
        if (this.trailingElse() != null) {
            builder.else_(var.assign((CodeChunk.WithValue)this.trailingElse()));
        }
        return var.withInitialStatements(ImmutableList.of(decl, builder.build()));
    }
}

