/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.ibm.icu.util.ULocale;
import java.util.Iterator;
import javax.annotation.Nullable;

public abstract class SoyMsgBundle
implements Iterable<SoyMsg> {
    public static final SoyMsgBundle EMPTY = new SoyMsgBundle(){

        @Override
        public String getLocaleString() {
            return "en";
        }

        @Override
        @Nullable
        public ULocale getLocale() {
            return ULocale.ENGLISH;
        }

        @Override
        public SoyMsg getMsg(long msgId) {
            return null;
        }

        @Override
        public ImmutableList<SoyMsgPart> getMsgParts(long msgId) {
            return ImmutableList.of();
        }

        @Override
        public boolean isRtl() {
            return false;
        }

        @Override
        public int getNumMsgs() {
            return 0;
        }

        @Override
        public Iterator<SoyMsg> iterator() {
            return ImmutableList.of().iterator();
        }
    };

    @Nullable
    public abstract String getLocaleString();

    public boolean isRtl() {
        return BidiGlobalDir.forStaticLocale(this.getLocaleString()) == BidiGlobalDir.RTL;
    }

    @Nullable
    public ULocale getLocale() {
        return this.getLocaleString() == null ? null : new ULocale(this.getLocaleString());
    }

    public ImmutableList<SoyMsgPart> getMsgParts(long msgId) {
        SoyMsg msg = this.getMsg(msgId);
        return msg == null ? ImmutableList.of() : msg.getParts();
    }

    public abstract SoyMsg getMsg(long var1);

    public abstract int getNumMsgs();

    @Override
    public abstract Iterator<SoyMsg> iterator();
}

